/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.reflect;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class DescribeClass {
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    private static void describe(Field f) {
        out.print("  ");
        out.print(Modifier.toString(f.getModifiers()));
        out.print(" ");
        out.print(f.getType().getName());
        out.print(" ");
        out.println(f.getName());
    }

    private static void describe(Method m) {
        out.print("  ");
        out.print(Modifier.toString(m.getModifiers()));
        out.print(" ");
        out.print(m.getReturnType().getName());
        out.print(" ");
        out.print(m.getName());
        out.print("(");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            out.print(params[i].getName());
            if (i >= params.length - 1) continue;
            out.print(", ");
        }
        out.println(")");
        Class<?>[] exs = m.getExceptionTypes();
        if (exs.length > 0) {
            out.print("    throws ");
            for (int i = 0; i < exs.length; ++i) {
                out.print(exs[i].getName());
                if (i >= exs.length - 1) continue;
                out.print(", ");
            }
            out.println("");
        }
    }

    private static void describe(Class c) {
        Class<?>[] ifaces;
        out.print(Modifier.toString(c.getModifiers()));
        out.print(" ");
        out.print(c.isInterface() ? "interface " : "class ");
        out.println(c.getName());
        Class superclass = c.getSuperclass();
        if (superclass != null) {
            out.print("  extends ");
            out.println(superclass.getName());
        }
        if ((ifaces = c.getInterfaces()).length > 0) {
            out.print("  implements ");
            for (int i = 0; i < ifaces.length; ++i) {
                out.print(ifaces[i].getName());
                if (i >= ifaces.length - 1) continue;
                out.print(", ");
            }
            out.println("");
        }
        out.println("{");
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            DescribeClass.describe(fields[i]);
        }
        out.println("");
        Method[] methods = c.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            DescribeClass.describe(methods[i]);
        }
        out.println("}");
    }

    public static void main(String[] args) {
        String className = args[0];
        try {
            Class<?> c = Class.forName(className);
            DescribeClass.describe(c);
        }
        catch (ClassNotFoundException ex) {
            err.println("Could not load " + className);
        }
    }
}

