/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.reflect;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class LoggingClassLoader
extends URLClassLoader {
    public LoggingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        System.out.println("Loading " + className);
        return super.loadClass(className);
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        String className = args[1];
        try {
            URL[] urls = new URL[]{file.toURL()};
            ClassLoader parent = ClassLoader.getSystemClassLoader();
            LoggingClassLoader cl = new LoggingClassLoader(urls, parent);
            ((ClassLoader)cl).loadClass(className);
        }
        catch (MalformedURLException ex) {
            String s = "Bad URL: " + ex;
            System.err.println(s);
        }
        catch (ClassNotFoundException ex) {
            String s = "Could not find class " + className;
            System.err.println(s);
        }
    }
}

