/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.rmi;

import edu.pdx.cs.joy.rmi.Matrix;
import java.io.PrintWriter;

public class GaussianElimination {
    public static double[] solve(double[][] a, double[] b) {
        int columns;
        int rows = Matrix.countRows(a);
        if (rows != (columns = Matrix.countColumns(a))) {
            String s = "Matrix a must have the same number of rows (" + rows + ") and columns (" + columns + ")";
            throw new IllegalArgumentException(s);
        }
        if (b.length != rows) {
            String s = "Vector b must have " + rows + " rows (not " + b.length + ")";
            throw new IllegalArgumentException(s);
        }
        PrintWriter pw = new PrintWriter(System.out, true);
        Matrix.print("Matrix A", a, pw);
        Matrix.print("Vector b", b, pw);
        int n = rows;
        double[] x = new double[n];
        double d = a[0][0];
        for (int h = 0; h < n; ++h) {
            a[0][h] = a[0][h] / d;
        }
        b[0] = b[0] / d;
        for (int k = 0; k < n; ++k) {
            for (int i = k + 1; i < n; ++i) {
                double multiplier = a[i][k] / a[k][k];
                for (int j = k; j < n; ++j) {
                    a[i][j] = a[i][j] - multiplier * a[k][j];
                }
                b[i] = b[i] - multiplier * b[k];
            }
        }
        for (int i = n - 1; i >= 0; --i) {
            double v = b[i];
            for (int j = i + 1; j < n; ++j) {
                v -= a[i][j] * x[j];
            }
            x[i] = v / a[i][i];
        }
        Matrix.print("Vector x", x, pw);
        return x;
    }
}

