/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.rmi;

import edu.pdx.cs.joy.rmi.Movie;
import edu.pdx.cs.joy.rmi.MovieDatabase;
import edu.pdx.cs.joy.rmi.Query;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Comparator;

public class GetMoviesInYear {
    public static void main(String[] args) {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int year = Integer.parseInt(args[2]);
        try {
            MovieDatabase db = (MovieDatabase)LocateRegistry.getRegistry(host, port).lookup("/MovieDatabase");
            Query query = movie -> movie.getYear() == year;
            SortMoviesByTitle sorter = new SortMoviesByTitle();
            db.executeQuery(query, sorter).forEach(System.out::println);
        }
        catch (NotBoundException | RemoteException ex) {
            ex.printStackTrace(System.err);
        }
    }

    static class SortMoviesByTitle
    implements Comparator<Movie>,
    Serializable {
        SortMoviesByTitle() {
        }

        @Override
        public int compare(Movie m1, Movie m2) {
            return m1.getTitle().compareTo(m2.getTitle());
        }
    }
}

