/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.rmi;

import java.io.PrintWriter;
import java.text.NumberFormat;

public class Matrix {
    private static NumberFormat format = NumberFormat.getNumberInstance();

    public static void setPrecision(int n) {
        format.setMinimumFractionDigits(n);
    }

    public static int countRows(double[][] m) {
        return m.length;
    }

    public static int countColumns(double[][] m) {
        int count = m[0].length;
        for (int i = 1; i < m.length; ++i) {
            if (m[i].length == count) continue;
            String s = "The matrix is not length-consistent (" + m[i].length + " != " + count + ")";
            throw new IllegalArgumentException(s);
        }
        return count;
    }

    public static double[][] multiply(double[][] a, double[][] b) {
        int aRows = Matrix.countRows(a);
        int aColumns = Matrix.countColumns(a);
        int bRows = Matrix.countRows(b);
        int bColumns = Matrix.countColumns(b);
        if (aColumns != bRows) {
            throw new IllegalArgumentException("Matrices cannot be multiplied");
        }
        int n = aColumns;
        double[][] c = new double[aRows][bColumns];
        for (int i = 0; i < aRows; ++i) {
            for (int j = 0; j < bColumns; ++j) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += a[i][k] * b[k][j];
                }
                c[i][j] = sum;
            }
        }
        return c;
    }

    public static void print(String name, double[][] m, PrintWriter out) {
        out.println("Matrix " + name + ":");
        for (int i = 0; i < Matrix.countRows(m); ++i) {
            out.print("  ");
            for (int j = 0; j < Matrix.countColumns(m); ++j) {
                out.print(format.format(m[i][j]) + " ");
            }
            out.println("");
        }
    }

    public static void print(String name, double[] v, PrintWriter out) {
        out.println("Vector " + name + ":");
        for (int i = 0; i < v.length; ++i) {
            out.println("  " + format.format(v[i]) + " ");
        }
    }
}

