/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.rmi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Movie
implements Serializable {
    private static long nextId = 0L;
    private long id = nextId++;
    private String title;
    private int year;
    private Map<String, Long> characters;
    private int numberOfAwards;

    Movie(String title, int year) {
        this.title = title;
        this.year = year;
        this.characters = new HashMap<String, Long>();
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Map<String, Long> getCharacters() {
        return this.characters;
    }

    public Set<Long> getActors() {
        return new HashSet<Long>(this.characters.values());
    }

    void addCharacter(String character, long actor) {
        Long a = this.characters.get(character);
        if (a != null && !a.equals(actor)) {
            String s = "The character " + character + " is already played by " + a;
            throw new IllegalArgumentException(s);
        }
        this.characters.put(character, actor);
    }

    public String toString() {
        return "Movie " + this.getId() + " \"" + this.getTitle() + "\" (" + this.getYear() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof Movie) {
            Movie other = (Movie)o;
            return this.getId() == other.getId();
        }
        return false;
    }

    public int getNumberOfAwards() {
        return this.numberOfAwards;
    }
}

