/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.rmi;

import edu.pdx.cs.joy.rmi.Movie;
import edu.pdx.cs.joy.rmi.MovieDatabase;
import edu.pdx.cs.joy.rmi.Query;
import java.io.Serializable;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class MovieDatabaseImpl
implements MovieDatabase {
    private Map<Long, Movie> movies = new TreeMap<Long, Movie>(Long::compareTo);

    public MovieDatabaseImpl() {
        System.out.println("Starting Movie Database");
    }

    @Override
    public long createMovie(String title, int year) {
        Movie movie = new Movie(title, year);
        long id = movie.getId();
        this.movies.put(id, movie);
        System.out.println("Created a new movie " + movie);
        return id;
    }

    @Override
    public Movie getMovie(long id) {
        return this.movies.get(id);
    }

    @Override
    public void noteCharacter(long movieId, String character, long actorId) {
        Movie movie = this.getExistingMovie(movieId);
        movie.addCharacter(character, actorId);
    }

    private Movie getExistingMovie(long movieId) {
        Movie movie = this.getMovie(movieId);
        if (movie == null) {
            String s = "There is no movie with id " + movieId;
            throw new IllegalArgumentException(s);
        }
        return movie;
    }

    @Override
    public SortedSet<Movie> getFilmography(long actorId) {
        Query query = movie -> movie.getActors().contains(actorId);
        SortMoviesByReleaseDate sorter = new SortMoviesByReleaseDate();
        return this.executeQuery(query, sorter);
    }

    @Override
    public SortedSet<Movie> executeQuery(Query query, Comparator<Movie> sorter) {
        return this.movies.values().stream().filter(query::satisfies).collect(Collectors.toCollection(() -> new TreeSet(sorter)));
    }

    @Override
    public void shutdown() throws RemoteException {
        System.out.println("Shutting down Movie Database");
        UnicastRemoteObject.unexportObject(this, false);
        System.exit(0);
    }

    @Override
    public Collection<Movie> getMovies() {
        return new HashSet<Movie>(this.movies.values());
    }

    @Override
    public void deleteMovie(long movieId) {
        Movie movie = this.getExistingMovie(movieId);
        this.movies.remove(movie.getId());
    }

    public static void main(String[] args) {
        int port = Integer.parseInt(args[0]);
        try {
            MovieDatabase database = (MovieDatabase)UnicastRemoteObject.exportObject((Remote)new MovieDatabaseImpl(), port);
            Registry registry = LocateRegistry.createRegistry(port);
            registry.bind("/MovieDatabase", database);
        }
        catch (AlreadyBoundException | RemoteException ex) {
            ex.printStackTrace(System.err);
        }
    }

    static class SortMoviesByReleaseDate
    implements Comparator<Movie>,
    Serializable {
        SortMoviesByReleaseDate() {
        }

        @Override
        public int compare(Movie movie1, Movie movie2) {
            int year1 = movie1.getYear();
            int year2 = movie2.getYear();
            return Integer.compare(year1, year2);
        }
    }
}

