/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.rmi;

import edu.pdx.cs.joy.rmi.Movie;
import edu.pdx.cs.joy.rmi.MovieDatabase;
import java.io.PrintStream;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Map;

public class NoteCharacter {
    private static PrintStream out = System.out;

    public static void main(String[] args) {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        long movieId = Long.parseLong(args[2]);
        String character = args[3];
        long actorId = Long.parseLong(args[4]);
        try {
            MovieDatabase db = (MovieDatabase)LocateRegistry.getRegistry(host, port).lookup("/MovieDatabase");
            db.noteCharacter(movieId, character, actorId);
            Movie movie = db.getMovie(movieId);
            out.println(movie.getTitle());
            for (Map.Entry<String, Long> entry : movie.getCharacters().entrySet()) {
                out.println("  " + entry.getKey() + "\t" + entry.getValue());
            }
            System.exit(0);
        }
        catch (NotBoundException | RemoteException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

