/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.security;

import edu.pdx.cs.joy.security.Game;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class GameConsole {
    public boolean writePreferences(Game game, String prefs) {
        String home = System.getProperty("user.home");
        try {
            File dir = new File(home, ".games");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, game.getName());
            FileWriter fw = new FileWriter(file);
            fw.write(prefs);
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public String readPreferences(Game game) {
        String home = System.getProperty("user.home");
        try {
            File file;
            File dir = new File(home, ".games");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(file = new File(dir, game.getName())).exists()) {
                return "";
            }
            if (file.isDirectory()) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            char[] arr = new char[1024];
            FileReader fr = new FileReader(file);
            while (fr.ready()) {
                fr.read(arr, 0, arr.length);
                sb.append(arr);
            }
            return sb.toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Game loadGame(String gameName, String gameURL) throws Exception {
        URL[] urls = new URL[]{new URL(gameURL)};
        URLClassLoader loader = new URLClassLoader(urls);
        Class<?> gameClass = loader.loadClass(gameName);
        Game game = (Game)gameClass.newInstance();
        return game;
    }

    public static void main(String[] args) {
        String gameName = args[0];
        String gameURL = args[1];
        GameConsole console = new GameConsole();
        try {
            Game game = console.loadGame(gameName, gameURL);
            game.play(console);
        }
        catch (Exception ex) {
            System.err.println("** Could not load game " + gameName + " from " + gameURL);
            System.err.println("** " + ex);
        }
    }
}

