/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.security;

import edu.pdx.cs.joy.security.Game;
import edu.pdx.cs.joy.security.GameConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class GuessingGame
implements Game {
    private PrintStream out = System.out;
    private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    @Override
    public String getName() {
        return "GuessingGame";
    }

    @Override
    public void play(GameConsole console) {
        int number = (int)(Math.random() * 10.0) + 1;
        this.out.println("I'm thinking of a number between 1 and 10");
        Object prefs = console.readPreferences(this);
        if (prefs == null) {
            System.err.println("** Couldn't read preferences");
            return;
        }
        int highScore = -1;
        try {
            highScore = Integer.parseInt(((String)prefs).trim());
            this.out.println("The high score is: " + highScore);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int guesses = 1;
        while (true) {
            this.out.print("Your guess: ");
            int guess = this.getGuess();
            if (guess < 1 || guess > 10) {
                this.out.println("Guess a number between 1 and 10");
            } else if (guess > number) {
                this.out.println("Too high!");
            } else {
                if (guess >= number) break;
                this.out.println("Too low!");
            }
            ++guesses;
        }
        this.out.println("You guessed right!");
        this.out.println("It took you " + guesses + " guesses");
        if (highScore == -1 || guesses < highScore) {
            this.out.println("A new high score!");
            prefs = "" + guesses;
            if (!console.writePreferences(this, (String)prefs)) {
                System.err.println("** Couldn't write preferences");
            }
        }
        this.out.println("Thanks for playing");
    }

    private int getGuess() {
        try {
            return Integer.parseInt(this.in.readLine());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
        catch (IOException ex) {
            return -1;
        }
    }

    public static void main(String[] args) {
        GameConsole console = new GameConsole();
        GuessingGame game = new GuessingGame();
        game.play(console);
    }
}

