/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class VerifyMessage {
    public static void main(String[] args) {
        String fileName = args[0];
        String digestName = args[1];
        String message = args[2];
        try {
            FileInputStream fis = new FileInputStream(fileName);
            byte[] encodedKey = new byte[fis.available()];
            fis.read(encodedKey);
            fis.close();
            X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedKey);
            KeyFactory factory = KeyFactory.getInstance("DSA", "SUN");
            PublicKey publicKey = factory.generatePublic(spec);
            fis = new FileInputStream(digestName);
            byte[] digest = new byte[fis.available()];
            fis.read(digest);
            fis.close();
            Signature sig = Signature.getInstance("DSA");
            sig.initVerify(publicKey);
            sig.update(message.getBytes());
            if (sig.verify(digest)) {
                System.out.println("Success");
            } else {
                System.out.println("Failure");
            }
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (NoSuchProviderException ex) {
            ex.printStackTrace(System.err);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace(System.err);
        }
        catch (InvalidKeySpecException ex) {
            ex.printStackTrace(System.err);
        }
        catch (SignatureException ex) {
            ex.printStackTrace(System.err);
        }
        catch (InvalidKeyException ex) {
            ex.printStackTrace(System.err);
        }
        System.exit(1);
    }
}

