/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpRequestHelper {
    private final String urlString;

    public HttpRequestHelper(String urlString) {
        this.urlString = urlString;
    }

    public Response get(Map<String, String> parameters) throws IOException {
        StringBuilder query = this.encodeParameters(parameters);
        if (query.length() > 0) {
            query.insert(0, '?');
        }
        URL url = new URL(this.urlString + query);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        return new Response(conn);
    }

    public Response post(Map<String, String> parameters) throws IOException {
        return this.sendEncodedRequest(this.urlString, "POST", parameters);
    }

    public Response delete(Map<String, String> parameters) throws IOException {
        return this.sendEncodedRequest(this.urlString, "DELETE", parameters);
    }

    private Response sendEncodedRequest(String urlString, String requestMethod, Map<String, String> parameters) throws IOException {
        StringBuilder data = this.encodeParameters(parameters);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(requestMethod);
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
        wr.write(data.toString());
        wr.flush();
        Response response = new Response(conn);
        wr.close();
        return response;
    }

    private StringBuilder encodeParameters(Map<String, String> parameters) {
        StringBuilder query = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> pair = iter.next();
            String key = pair.getKey();
            String value = pair.getValue();
            query.append(URLEncoder.encode(key, StandardCharsets.UTF_8));
            query.append("=");
            query.append(URLEncoder.encode(value, StandardCharsets.UTF_8));
            if (!iter.hasNext()) continue;
            query.append("&");
        }
        return query;
    }

    public Response put(Map<String, String> parameters) throws IOException {
        StringBuilder data = new StringBuilder();
        parameters.forEach((key, value) -> {
            data.append((String)key);
            data.append("=");
            data.append((String)value);
            data.append("\n");
        });
        URL url = new URL(this.urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setRequestProperty("Context-Length", String.valueOf(data.length()));
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
        wr.write(data.toString());
        wr.flush();
        Response response = new Response(conn);
        wr.close();
        return response;
    }

    private static Map<String, String> arrayToMap(String[] parameters) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; ++i) {
            String key = parameters[i];
            String value = parameters[++i];
            params.put(key, value);
        }
        return params;
    }

    public static void main(String[] args) throws IOException {
        Response response;
        String method = args[0];
        String url = args[1];
        String[] parameters = new String[args.length - 2];
        System.arraycopy(args, 2, parameters, 0, parameters.length);
        Map<String, String> map = HttpRequestHelper.arrayToMap(parameters);
        HttpRequestHelper helper = new HttpRequestHelper(url);
        if (method.equalsIgnoreCase("PUT")) {
            response = helper.put(map);
        } else if (method.equalsIgnoreCase("GET")) {
            response = helper.get(map);
        } else if (method.equalsIgnoreCase("POST")) {
            response = helper.post(map);
        } else {
            System.err.println("** Unknown method: " + method);
            return;
        }
        System.out.println("Returned code " + response.getHttpStatusCode() + " and " + response.getContentLines() + " lines of content\n");
        System.out.println(response.getContent());
    }

    public static class Response {
        private final int httpStatusCode;
        private final String content;
        private int contentLines = 0;

        private Response(HttpURLConnection conn) throws IOException {
            this.httpStatusCode = conn.getResponseCode();
            InputStream stream = this.httpStatusCode != 200 ? conn.getErrorStream() : conn.getInputStream();
            StringBuilder content = new StringBuilder();
            if (stream != null) {
                String line;
                BufferedReader rd = new BufferedReader(new InputStreamReader(stream));
                while ((line = rd.readLine()) != null) {
                    content.append(line);
                    content.append("\n");
                    ++this.contentLines;
                }
                rd.close();
            }
            this.content = content.toString().trim();
        }

        @VisibleForTesting
        public Response(String content) {
            this.content = content;
            this.httpStatusCode = 200;
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public String getContent() {
            return this.content;
        }

        public int getContentLines() {
            return this.contentLines;
        }
    }

    public static class RestException
    extends RuntimeException {
        private final int httpStatusCode;

        public RestException(int httpStatusCode, String message) {
            super("HTTP Status Code " + httpStatusCode + ": " + message);
            this.httpStatusCode = httpStatusCode;
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode;
        }
    }
}

