/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.xml;

import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class BuildPhonebook {
    private static final PrintStream err = System.err;

    public static void main(String[] args) {
        Document doc = null;
        String publicID = null;
        String systemID = null;
        try {
            File dtd = new File("phonebook.dtd");
            systemID = dtd.toURL().toString();
        }
        catch (MalformedURLException ex) {
            err.println("** Bad URL: " + ex);
            System.exit(1);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation dom = builder.getDOMImplementation();
            DocumentType docType = dom.createDocumentType("phonebook", publicID, systemID);
            doc = dom.createDocument(null, "phonebook", docType);
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        catch (DOMException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        try {
            Element root = doc.getDocumentElement();
            Element biz = doc.createElement("business");
            root.appendChild(biz);
            Element name = doc.createElement("name");
            biz.appendChild(name);
            String br = "Tripwire, Inc.";
            name.appendChild(doc.createTextNode(br));
            Element address = doc.createElement("address");
            biz.appendChild(address);
            Element street1 = doc.createElement("street");
            address.appendChild(street1);
            String st1 = "308 SW 2nd Ave";
            street1.appendChild(doc.createTextNode(st1));
            Element street2 = doc.createElement("street");
            address.appendChild(street2);
            String st2 = "Suite 400";
            street2.appendChild(doc.createTextNode(st2));
            Element city = doc.createElement("city");
            address.appendChild(city);
            city.appendChild(doc.createTextNode("Portland"));
            Element state = doc.createElement("state");
            address.appendChild(state);
            state.appendChild(doc.createTextNode("OR"));
            Element zip = doc.createElement("zip");
            address.appendChild(zip);
            zip.appendChild(doc.createTextNode("97205"));
            Element phone = doc.createElement("phone");
            biz.appendChild(phone);
            phone.setAttribute("areacode", "503");
            phone.setAttribute("number", "276-7500");
        }
        catch (DOMException ex) {
            ex.printStackTrace(err);
            System.exit(1);
        }
        try {
            DOMSource src = new DOMSource(doc);
            StreamResult res = new StreamResult(System.out);
            TransformerFactory xFactory = TransformerFactory.newInstance();
            Transformer xform = xFactory.newTransformer();
            xform.setOutputProperty("indent", "yes");
            xform.setOutputProperty("doctype-system", systemID);
            xform.transform(src, res);
        }
        catch (TransformerException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

