/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.xml;

import edu.pdx.cs.joy.xml.Business;
import edu.pdx.cs.joy.xml.PhoneBookEntry;
import edu.pdx.cs.joy.xml.Resident;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PhoneBook {
    private static PrintStream err = System.err;
    private Collection<PhoneBookEntry> entries = new ArrayList<PhoneBookEntry>();

    public PhoneBook(Element root) {
        if (!root.getNodeName().equals("phonebook")) {
            String s = "Not a phonebook: " + root.getNodeName();
            throw new IllegalArgumentException(s);
        }
        NodeList entries = root.getChildNodes();
        block8: for (int i = 0; i < entries.getLength(); ++i) {
            Node node = entries.item(i);
            if (!(node instanceof Element)) continue;
            Element entry = (Element)node;
            switch (entry.getNodeName()) {
                case "resident": {
                    this.entries.add(new Resident(entry));
                    continue block8;
                }
                case "business": {
                    this.entries.add(new Business(entry));
                    continue block8;
                }
                default: {
                    String s = "Unknown entry: " + entry.getNodeName() + " (" + entry.getNodeValue() + ")";
                    throw new IllegalArgumentException(s);
                }
            }
        }
    }

    public static void main(String[] args) {
        Node doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(new File(args[0]));
        }
        catch (ParserConfigurationException ex) {
            err.println("** " + ex);
            System.exit(1);
        }
        catch (SAXException ex) {
            err.println("** SAXException: " + ex);
            System.exit(1);
        }
        catch (IOException ex) {
            err.println("** IOException: " + ex);
            System.exit(1);
        }
        Element root = (Element)doc.getChildNodes().item(1);
        PhoneBook phonebook = new PhoneBook(root);
        System.out.println(phonebook);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Phone Book\n\n");
        for (PhoneBookEntry entry : this.entries) {
            sb.append(entry);
            sb.append("\n");
        }
        return sb.toString();
    }
}

