/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.xml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PhoneBookEntry {
    protected List<String> streetLines = new ArrayList<String>();
    protected String apt;
    protected String city;
    protected String state;
    protected String zip;
    protected String phone;

    protected void fillInAddress(Element root) {
        NodeList elements = root.getChildNodes();
        block14: for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            switch (element.getNodeName()) {
                case "street": {
                    Node text = element.getFirstChild();
                    this.streetLines.add(text.getNodeValue());
                    continue block14;
                }
                case "apt": {
                    Node text = element.getFirstChild();
                    this.apt = text.getNodeValue();
                    continue block14;
                }
                case "city": {
                    Node text = element.getFirstChild();
                    this.city = text.getNodeValue();
                    continue block14;
                }
                case "state": {
                    Node text = element.getFirstChild();
                    this.state = text.getNodeValue();
                    continue block14;
                }
                case "zip": {
                    Node text = element.getFirstChild();
                    this.zip = text.getNodeValue();
                    continue block14;
                }
            }
        }
    }

    protected void fillInPhone(Element phone) {
        String areacode = null;
        String number = null;
        NamedNodeMap attrs = phone.getAttributes();
        block8: for (int i = 0; i < attrs.getLength(); ++i) {
            String nodeName;
            Node attr = attrs.item(i);
            switch (nodeName = attr.getNodeName()) {
                case "areacode": {
                    areacode = attr.getNodeValue();
                    continue block8;
                }
                case "number": {
                    number = attr.getNodeValue();
                    continue block8;
                }
            }
        }
        this.phone = areacode + "-" + number;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.streetLines) {
            sb.append(line);
            sb.append("\n");
        }
        if (this.apt != null) {
            sb.append("Apt ").append(this.apt).append("\n");
        }
        sb.append(this.city).append(", ").append(this.state).append(" ").append(this.zip).append("\n");
        sb.append(this.phone).append("\n");
        return sb.toString();
    }
}

