/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PrintPhoneNumbers
extends DefaultHandler {
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("phone")) {
            String area = attrs.getValue("areacode");
            String number = attrs.getValue("number");
            out.println("(" + area + ") " + number);
        }
    }

    @Override
    public void warning(SAXParseException ex) {
        err.println("WARNING: " + ex);
    }

    @Override
    public void error(SAXParseException ex) {
        err.println("ERROR: " + ex);
    }

    @Override
    public void fatalError(SAXParseException ex) {
        err.println("FATAL: " + ex);
    }

    public static void main(String[] args) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        catch (SAXException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        PrintPhoneNumbers handler = new PrintPhoneNumbers();
        try {
            File file = new File(args[0]);
            InputSource source = new InputSource(new FileReader(file));
            source.setSystemId(file.toURL().toString());
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (SAXException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

