/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.Dumper;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Parser;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.TextDumper;
import edu.pdx.cs.joy.family.TextParser;
import edu.pdx.cs.joy.family.XmlDumper;
import edu.pdx.cs.joy.family.XmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class AddPerson {
    private static final PrintStream err = System.err;
    private static int id = 0;
    private static String gender;
    private static String fileName;
    private static boolean useXml;
    private static String firstName;
    private static String middleName;
    private static String lastName;
    private static Date dob;
    private static Date dod;
    private static int childId;

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("Adds a person to a family tree");
        err.println("usage: java AddPerson [options] <args>");
        err.println("  args are (in this order):");
        err.println("    file         File to store data in");
        err.println("    id           Person's id (greater or equal to 1)");
        err.println("    gender       Person's gender (male or female)");
        err.println("    firstName    Person's first name");
        err.println("    middleName   Person's middle name");
        err.println("    lastName     Person's last name");
        err.println("    dob          Person's date of birth (e.g. Jun 27, 1936)");
        err.println("  options are (options may appear in any order):");
        err.println("    -parentOf id       Person's child");
        err.println("    -dod date          Person's date of death (e.g. Jan 12, 1987)");
        err.println("    -xml               File in XML format instead of text");
        err.println("\n");
        System.exit(1);
    }

    private static String parseCommandLine(String[] args) {
        DateFormat df = DateFormat.getDateInstance(2);
        df.setLenient(false);
        for (int i = 0; i < args.length; ++i) {
            int j;
            StringBuffer sb;
            if (args[i].equals("-xml")) {
                useXml = true;
                continue;
            }
            if (args[i].equals("-dod")) {
                if (++i >= args.length) {
                    return "Missing date of death";
                }
                sb = new StringBuffer();
                for (j = 0; j < 3; ++j) {
                    if (i >= args.length) {
                        return "Malformatted date of death: " + sb;
                    }
                    sb.append(args[i]).append(" ");
                    ++i;
                }
                try {
                    dod = df.parse(sb.toString().trim());
                    continue;
                }
                catch (ParseException ex) {
                    return "Malformatted date of death: " + sb;
                }
            }
            if (args[i].equals("-parentOf")) {
                if (++i >= args.length) {
                    return "No child id specified";
                }
                try {
                    childId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    return "Malformatted child id: " + args[i];
                }
                if (childId >= 1) continue;
                return "Invalid child id value: " + childId;
            }
            if (fileName == null) {
                fileName = args[i];
                continue;
            }
            if (id == 0) {
                try {
                    id = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    return "Malformatted id: " + args[i];
                }
                if (id >= 1) continue;
                return "Invalid id value: " + id;
            }
            if (gender == null) {
                gender = args[i];
                continue;
            }
            if (firstName == null) {
                firstName = args[i];
                continue;
            }
            if (middleName == null) {
                middleName = args[i];
                continue;
            }
            if (lastName == null) {
                lastName = args[i];
                continue;
            }
            if (dob == null) {
                sb = new StringBuffer();
                for (j = 0; j < 3; ++j) {
                    if (i >= args.length) {
                        return "Malformatted date of birth: " + sb;
                    }
                    sb.append(args[i]).append(" ");
                    ++i;
                }
                try {
                    dob = df.parse(sb.toString().trim());
                    continue;
                }
                catch (ParseException ex) {
                    return "Malformatted date of birth: " + sb;
                }
            }
            return "Unknown command line option: " + args[i];
        }
        if (id == 0) {
            return "No id specified";
        }
        if (fileName == null) {
            return "No file name specified";
        }
        if (gender == null) {
            return "Missing gender";
        }
        if (firstName == null) {
            return "Missing first name";
        }
        if (middleName == null) {
            return "Missing middle name";
        }
        if (lastName == null) {
            return "Missing last name";
        }
        return null;
    }

    public static void main(String[] args) {
        Object s;
        Person person;
        String message = AddPerson.parseCommandLine(args);
        if (message != null) {
            AddPerson.usage(message);
        }
        FamilyTree tree = null;
        File file = new File(fileName);
        if (file.exists()) {
            Parser parser = null;
            if (useXml) {
                try {
                    parser = new XmlParser(file);
                }
                catch (FileNotFoundException ex) {
                    err.println("** Could not find file " + fileName);
                    System.exit(1);
                }
            } else {
                try {
                    parser = new TextParser(file);
                }
                catch (FileNotFoundException ex) {
                    err.println("** Could not find file " + fileName);
                    System.exit(1);
                }
            }
            try {
                tree = parser.parse();
            }
            catch (FamilyTreeException ex) {
                err.println("** File " + fileName + " is malformatted");
                System.exit(1);
            }
        } else {
            tree = new FamilyTree();
        }
        if ((person = tree.getPerson(id)) == null) {
            Person.Gender g;
            if (gender == null) {
                s = "Must specify a gender when creating a new person";
                err.println((String)s);
                System.exit(1);
                g = null;
            } else if (gender.equalsIgnoreCase("male")) {
                g = Person.MALE;
            } else if (gender.equalsIgnoreCase("female")) {
                g = Person.FEMALE;
            } else {
                err.println("** Illegal gender: " + gender);
                System.exit(1);
                g = null;
            }
            person = new Person(id, g);
            tree.addPerson(person);
        }
        person.setFirstName(firstName);
        person.setMiddleName(middleName);
        person.setLastName(lastName);
        if (dob != null) {
            person.setDateOfBirth(dob);
        }
        if (dod != null) {
            person.setDateOfDeath(dod);
        }
        if (childId != 0) {
            Person child = tree.getPerson(childId);
            if (child == null) {
                s = "The child with id " + childId + " does not exist";
                err.println("\n** " + (String)s + "\n");
                System.exit(1);
            }
            if (person.getGender() == Person.MALE) {
                child.setFather(person);
            } else {
                child.setMother(person);
            }
        }
        Dumper dumper = null;
        if (useXml) {
            try {
                dumper = new XmlDumper(file);
            }
            catch (IOException ex) {
                err.println("** Error while dealing with " + file);
                System.exit(1);
            }
        } else {
            try {
                dumper = new TextDumper(file);
            }
            catch (IOException ex) {
                err.println("** Error while dealing with " + file);
                System.exit(1);
            }
        }
        dumper.dump(tree);
    }

    static {
        useXml = false;
        childId = 0;
    }
}

