/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PrettyPrinter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class AddPersonDialog
extends JDialog {
    private Person newPerson = null;
    private Person mother;
    private Person father;

    public AddPersonDialog(JFrame owner, FamilyTree tree) {
        super(owner, "Add New Person", true);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(0, 2));
        Border infoBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        infoPanel.setBorder(infoBorder);
        infoPanel.add(new JLabel("id:"));
        final JTextField idField = new JTextField();
        infoPanel.add(idField);
        final ButtonGroup group = new ButtonGroup();
        final JRadioButton male = new JRadioButton("male", true);
        group.add(male);
        infoPanel.add(male);
        JRadioButton female = new JRadioButton("female");
        group.add(female);
        infoPanel.add(female);
        infoPanel.add(new JLabel("First name:"));
        final JTextField firstNameField = new JTextField();
        infoPanel.add(firstNameField);
        infoPanel.add(new JLabel("Middle name:"));
        final JTextField middleNameField = new JTextField();
        infoPanel.add(middleNameField);
        infoPanel.add(new JLabel("Last name:"));
        final JTextField lastNameField = new JTextField();
        infoPanel.add(lastNameField);
        infoPanel.add(new JLabel("Date of Birth:"));
        final JTextField dobField = new JTextField();
        infoPanel.add(dobField);
        infoPanel.add(new JLabel("Date of Death:"));
        final JTextField dodField = new JTextField();
        infoPanel.add(dodField);
        infoPanel.add(new JLabel("Father:"));
        JPanel fatherPanel = new JPanel();
        fatherPanel.setLayout(new FlowLayout());
        JTextField fatherText = new JTextField("Click to choose");
        fatherText.setEditable(false);
        fatherText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("Clicked father");
            }
        });
        fatherPanel.add(fatherText);
        infoPanel.add(fatherPanel);
        infoPanel.add(new JLabel("Mother:"));
        JPanel motherPanel = new JPanel();
        motherPanel.setLayout(new FlowLayout());
        JTextField motherText = new JTextField("Click to choose");
        motherText.setEditable(false);
        motherText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("Clicked mother");
            }
        });
        motherPanel.add(motherText);
        infoPanel.add(motherPanel);
        pane.add((Component)infoPanel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = 0;
                try {
                    id = Integer.parseInt(idField.getText());
                }
                catch (NumberFormatException ex) {
                    AddPersonDialog.this.error("Invalid id: " + idField.getText());
                    return;
                }
                String text = null;
                text = dobField.getText();
                Date dob = null;
                if (text != null && !text.equals("") && (dob = AddPersonDialog.this.parseDate(dobField.getText())) == null) {
                    return;
                }
                text = dodField.getText();
                Date dod = null;
                if (text != null && !text.equals("") && (dod = AddPersonDialog.this.parseDate(dodField.getText())) == null) {
                    return;
                }
                Person.Gender gender = group.getSelection().equals(male) ? Person.MALE : Person.FEMALE;
                AddPersonDialog.this.newPerson = new Person(id, gender);
                AddPersonDialog.this.newPerson.setFirstName(firstNameField.getText());
                AddPersonDialog.this.newPerson.setMiddleName(middleNameField.getText());
                AddPersonDialog.this.newPerson.setLastName(lastNameField.getText());
                AddPersonDialog.this.newPerson.setDateOfBirth(dob);
                AddPersonDialog.this.newPerson.setDateOfDeath(dod);
                if (AddPersonDialog.this.mother != null) {
                    AddPersonDialog.this.newPerson.setMother(AddPersonDialog.this.mother);
                }
                if (AddPersonDialog.this.father != null) {
                    AddPersonDialog.this.newPerson.setFather(AddPersonDialog.this.father);
                }
                AddPersonDialog.this.dispose();
            }
        });
        buttonPanel.add(addButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPersonDialog.this.newPerson = null;
                AddPersonDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        pane.add((Component)buttonPanel, "South");
    }

    public Person getPerson() {
        return this.newPerson;
    }

    private Date parseDate(String text) {
        DateFormat[] formats = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0)};
        for (int i = 0; i < formats.length; ++i) {
            DateFormat df = formats[i];
            try {
                Date date = df.parse(text);
                return date;
            }
            catch (ParseException ex) {
                continue;
            }
        }
        this.error("Could not parse date: " + text);
        return null;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, new String[]{message}, "Error.", 0);
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Testing AddPersonDialog");
        JButton button = new JButton("Click me");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTree tree = new FamilyTree();
                AddPersonDialog dialog = new AddPersonDialog(frame, tree);
                dialog.pack();
                dialog.setLocationRelativeTo(frame);
                dialog.setVisible(true);
                Person newPerson = dialog.getPerson();
                if (newPerson != null) {
                    tree.addPerson(newPerson);
                    PrettyPrinter pretty = new PrettyPrinter(new PrintWriter(System.out, true));
                    pretty.dump(tree);
                }
            }
        });
        frame.getContentPane().add(button);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

