/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.ChoosePersonDialog;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Person;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class EditMarriageDialog
extends JDialog {
    private Marriage marriage = null;
    private Person husband = null;
    private Person wife = null;
    private boolean changeHusband = true;
    private boolean changeWife = true;
    private JTextField husbandField = new JTextField("Click to choose");
    private JTextField wifeField = new JTextField("Click to choose");
    private JTextField dateField = new JTextField();
    private JTextField locationField = new JTextField();

    public EditMarriageDialog(JFrame owner, FamilyTree tree) {
        this(owner, "Add New Marriage", tree);
    }

    public EditMarriageDialog(Person spouse, JFrame owner, FamilyTree tree) {
        this(owner, "Creating Marriage", tree);
        if (spouse.getGender() == Person.MALE) {
            this.husband = spouse;
            this.husbandField.setText(this.husband.getFullName());
            this.husbandField.setEditable(false);
            this.changeHusband = false;
        } else {
            this.wife = spouse;
            this.wifeField.setText(this.wife.getFullName());
            this.wifeField.setEditable(false);
            this.changeWife = false;
        }
        this.marriage = null;
    }

    public EditMarriageDialog(Marriage marriage, JFrame owner, FamilyTree tree) {
        this(owner, "Edit Marriage", tree);
        this.marriage = marriage;
        this.husband = marriage.getHusband();
        this.husbandField.setText(this.husband.getFullName());
        this.husbandField.setEditable(false);
        this.wife = marriage.getWife();
        this.wifeField.setText(this.wife.getFullName());
        this.wifeField.setEditable(false);
        Date date = marriage.getDate();
        if (date != null) {
            DateFormat df = DateFormat.getDateInstance(1);
            this.dateField.setText(df.format(date));
        }
        String location = marriage.getLocation();
        this.locationField.setText(location);
    }

    private EditMarriageDialog(JFrame owner, String title, FamilyTree tree) {
        super(owner, title, true);
        this.setupComponents(tree);
    }

    private void setupComponents(final FamilyTree tree) {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(4, 2));
        Border infoBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        infoPanel.setBorder(infoBorder);
        infoPanel.add(new JLabel("Husband:"));
        this.husbandField.setEditable(false);
        this.husbandField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!EditMarriageDialog.this.changeHusband) {
                    return;
                }
                ChoosePersonDialog dialog = new ChoosePersonDialog(tree, EditMarriageDialog.this);
                dialog.pack();
                dialog.setLocationRelativeTo(EditMarriageDialog.this);
                dialog.setVisible(true);
                Person husband = dialog.getPerson();
                if (husband != null) {
                    EditMarriageDialog.this.husband = husband;
                    String husbandName = EditMarriageDialog.this.husband.getFullName();
                    EditMarriageDialog.this.husbandField.setText(husbandName);
                }
            }
        });
        infoPanel.add(this.husbandField);
        infoPanel.add(new JLabel("Wife:"));
        this.wifeField.setEditable(false);
        this.wifeField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!EditMarriageDialog.this.changeWife) {
                    return;
                }
                ChoosePersonDialog dialog = new ChoosePersonDialog(tree, EditMarriageDialog.this);
                dialog.pack();
                dialog.setLocationRelativeTo(EditMarriageDialog.this);
                dialog.setVisible(true);
                Person wife = dialog.getPerson();
                if (wife != null) {
                    EditMarriageDialog.this.wife = wife;
                    String wifeName = EditMarriageDialog.this.wife.getFullName();
                    EditMarriageDialog.this.wifeField.setText(wifeName);
                }
            }
        });
        infoPanel.add(this.wifeField);
        infoPanel.add(new JLabel("Date:"));
        infoPanel.add(this.dateField);
        infoPanel.add(new JLabel("Location:"));
        infoPanel.add(this.locationField);
        pane.add((Component)infoPanel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditMarriageDialog.this.husband == null) {
                    EditMarriageDialog.this.error("Missing husband");
                    return;
                }
                if (EditMarriageDialog.this.wife == null) {
                    EditMarriageDialog.this.error("Missing wife");
                    return;
                }
                String text = null;
                text = EditMarriageDialog.this.dateField.getText();
                Date date = null;
                if (text != null && !text.equals("") && (date = EditMarriageDialog.this.parseDate(text)) == null) {
                    return;
                }
                if (EditMarriageDialog.this.marriage == null) {
                    EditMarriageDialog.this.marriage = new Marriage(EditMarriageDialog.this.husband, EditMarriageDialog.this.wife);
                    EditMarriageDialog.this.husband.addMarriage(EditMarriageDialog.this.marriage);
                    EditMarriageDialog.this.wife.addMarriage(EditMarriageDialog.this.marriage);
                }
                EditMarriageDialog.this.marriage.setDate(date);
                EditMarriageDialog.this.marriage.setLocation(EditMarriageDialog.this.locationField.getText());
                EditMarriageDialog.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMarriageDialog.this.marriage = null;
                EditMarriageDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        pane.add((Component)buttonPanel, "South");
    }

    public Marriage getMarriage() {
        return this.marriage;
    }

    private Date parseDate(String text) {
        DateFormat[] formats = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0)};
        for (int i = 0; i < formats.length; ++i) {
            DateFormat df = formats[i];
            try {
                Date date = df.parse(text);
                return date;
            }
            catch (ParseException ex) {
                continue;
            }
        }
        this.error("Could not parse date: " + text);
        return null;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, new String[]{message}, "Error.", 0);
    }
}

