/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.ChoosePersonDialog;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PrettyPrinter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class EditPersonDialog
extends JDialog {
    private Person person = null;
    private Person mother;
    private Person father;
    private Person child;
    private JTextField idField = new JTextField();
    private JTextField firstNameField = new JTextField();
    private JTextField middleNameField = new JTextField();
    private JTextField lastNameField = new JTextField();
    private JTextField dobField = new JTextField();
    private JTextField dodField = new JTextField();
    private JTextField fatherField = new JTextField("Click to choose");
    private JTextField motherField = new JTextField("Click to choose");
    private JTextField childField = new JTextField("Click to choose");
    private JRadioButton male = new JRadioButton("male", true);
    private JRadioButton female = new JRadioButton("female");

    public EditPersonDialog(JFrame owner, FamilyTree tree) {
        this(owner, "Add New Person", tree);
    }

    public EditPersonDialog(Person person, JFrame owner, FamilyTree tree) {
        this(owner, "Edit Person " + person.getId(), tree);
        Date dod;
        this.person = person;
        this.idField.setText("" + person.getId());
        this.idField.setEditable(false);
        if (this.person.getGender() == Person.FEMALE) {
            this.female.setSelected(true);
            this.female.setEnabled(true);
            this.male.setEnabled(false);
            this.male.setSelected(false);
        }
        if (this.person.getGender() == Person.MALE) {
            this.male.setSelected(true);
            this.male.setEnabled(true);
            this.female.setSelected(false);
            this.female.setEnabled(false);
        }
        this.firstNameField.setText(person.getFirstName());
        this.middleNameField.setText(person.getMiddleName());
        this.lastNameField.setText(person.getLastName());
        DateFormat df = DateFormat.getDateInstance(2);
        Date dob = person.getDateOfBirth();
        if (dob != null) {
            this.dobField.setText(df.format(dob));
        }
        if ((dod = person.getDateOfDeath()) != null) {
            this.dodField.setText(df.format(dod));
        }
        this.father = person.getFather();
        if (this.father != null) {
            this.fatherField.setText(this.father.getFullName());
        }
        this.mother = person.getMother();
        if (this.mother != null) {
            this.motherField.setText(this.mother.getFullName());
        }
    }

    private EditPersonDialog(JFrame owner, String title, FamilyTree tree) {
        super(owner, title, true);
        this.setupComponents(tree);
    }

    private void setupComponents(final FamilyTree tree) {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(0, 2));
        Border infoBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        infoPanel.setBorder(infoBorder);
        infoPanel.add(new JLabel("id:"));
        infoPanel.add(this.idField);
        final ButtonGroup group = new ButtonGroup();
        group.add(this.male);
        this.male.setActionCommand("male");
        infoPanel.add(this.male);
        group.add(this.female);
        this.female.setActionCommand("female");
        infoPanel.add(this.female);
        infoPanel.add(new JLabel("First name:"));
        infoPanel.add(this.firstNameField);
        infoPanel.add(new JLabel("Middle name:"));
        infoPanel.add(this.middleNameField);
        infoPanel.add(new JLabel("Last name:"));
        infoPanel.add(this.lastNameField);
        infoPanel.add(new JLabel("Date of Birth:"));
        infoPanel.add(this.dobField);
        infoPanel.add(new JLabel("Date of Death:"));
        infoPanel.add(this.dodField);
        infoPanel.add(new JLabel("Father:"));
        this.fatherField.setEditable(false);
        this.fatherField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChoosePersonDialog dialog = new ChoosePersonDialog(tree, EditPersonDialog.this);
                dialog.pack();
                dialog.setLocationRelativeTo(EditPersonDialog.this);
                dialog.setVisible(true);
                Person father = dialog.getPerson();
                if (father != null) {
                    EditPersonDialog.this.father = father;
                    String fatherName = EditPersonDialog.this.father.getFullName();
                    EditPersonDialog.this.fatherField.setText(fatherName);
                }
            }
        });
        infoPanel.add(this.fatherField);
        infoPanel.add(new JLabel("Mother:"));
        this.motherField.setEditable(false);
        this.motherField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChoosePersonDialog dialog = new ChoosePersonDialog(tree, EditPersonDialog.this);
                dialog.pack();
                dialog.setLocationRelativeTo(EditPersonDialog.this);
                dialog.setVisible(true);
                Person mother = dialog.getPerson();
                if (mother != null) {
                    EditPersonDialog.this.mother = mother;
                    String motherName = EditPersonDialog.this.mother.getFullName();
                    EditPersonDialog.this.motherField.setText(motherName);
                }
            }
        });
        infoPanel.add(this.motherField);
        infoPanel.add(new JLabel("Parent of:"));
        this.childField.setEditable(false);
        this.childField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChoosePersonDialog dialog = new ChoosePersonDialog(tree, EditPersonDialog.this);
                dialog.pack();
                dialog.setLocationRelativeTo(EditPersonDialog.this);
                dialog.setVisible(true);
                Person child = dialog.getPerson();
                if (child != null) {
                    EditPersonDialog.this.child = child;
                    String childName = EditPersonDialog.this.child.getFullName();
                    EditPersonDialog.this.childField.setText(childName);
                }
            }
        });
        infoPanel.add(this.childField);
        pane.add((Component)infoPanel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = 0;
                try {
                    id = Integer.parseInt(EditPersonDialog.this.idField.getText());
                }
                catch (NumberFormatException ex) {
                    EditPersonDialog.this.error("Invalid id: " + EditPersonDialog.this.idField.getText());
                    return;
                }
                String text = null;
                text = EditPersonDialog.this.dobField.getText();
                Date dob = null;
                if (text != null && !text.equals("") && (dob = EditPersonDialog.this.parseDate(EditPersonDialog.this.dobField.getText())) == null) {
                    return;
                }
                text = EditPersonDialog.this.dodField.getText();
                Date dod = null;
                if (text != null && !text.equals("") && (dod = EditPersonDialog.this.parseDate(EditPersonDialog.this.dodField.getText())) == null) {
                    return;
                }
                Person.Gender gender = group.getSelection().getActionCommand().equals("male") ? Person.MALE : Person.FEMALE;
                if (EditPersonDialog.this.person == null) {
                    EditPersonDialog.this.person = new Person(id, gender);
                }
                EditPersonDialog.this.person.setFirstName(EditPersonDialog.this.firstNameField.getText());
                EditPersonDialog.this.person.setMiddleName(EditPersonDialog.this.middleNameField.getText());
                EditPersonDialog.this.person.setLastName(EditPersonDialog.this.lastNameField.getText());
                EditPersonDialog.this.person.setDateOfBirth(dob);
                EditPersonDialog.this.person.setDateOfDeath(dod);
                if (EditPersonDialog.this.mother != null) {
                    EditPersonDialog.this.person.setMother(EditPersonDialog.this.mother);
                }
                if (EditPersonDialog.this.father != null) {
                    EditPersonDialog.this.person.setFather(EditPersonDialog.this.father);
                }
                if (EditPersonDialog.this.child != null) {
                    if (EditPersonDialog.this.person.getGender() == Person.MALE) {
                        EditPersonDialog.this.child.setFather(EditPersonDialog.this.person);
                    } else {
                        EditPersonDialog.this.child.setMother(EditPersonDialog.this.person);
                    }
                }
                EditPersonDialog.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPersonDialog.this.person = null;
                EditPersonDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalGlue());
        pane.add((Component)buttonPanel, "South");
    }

    public Person getPerson() {
        return this.person;
    }

    private Date parseDate(String text) {
        DateFormat[] formats = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0)};
        for (int i = 0; i < formats.length; ++i) {
            DateFormat df = formats[i];
            try {
                Date date = df.parse(text);
                return date;
            }
            catch (ParseException ex) {
                continue;
            }
        }
        this.error("Could not parse date: " + text);
        return null;
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, new String[]{message}, "Error.", 0);
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Testing EditPersonDialog");
        JButton button = new JButton("Click me");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTree tree = new FamilyTree();
                EditPersonDialog dialog = new EditPersonDialog(frame, tree);
                dialog.pack();
                dialog.setLocationRelativeTo(frame);
                dialog.setVisible(true);
                Person person = dialog.getPerson();
                if (person != null) {
                    tree.addPerson(person);
                    PrettyPrinter pretty = new PrettyPrinter(new PrintWriter(System.out, true));
                    pretty.dump(tree);
                }
            }
        });
        frame.getContentPane().add(button);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

