/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.EditMarriageDialog;
import edu.pdx.cs.joy.family.EditPersonDialog;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.FamilyTreePanel;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.XmlDumper;
import edu.pdx.cs.joy.family.XmlParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class FamilyTreeGUI
extends FamilyTreePanel {
    private File file;
    private boolean isDirty = false;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenu personMenu;
    private JMenuItem motherItem;
    private JMenuItem fatherItem;
    private JFrame frame;

    public FamilyTreeGUI(String title) {
        this.frame = new JFrame(title);
        JMenuBar menuBar = new JMenuBar();
        this.frame.setJMenuBar(menuBar);
        this.addFileMenu(menuBar);
        this.addPersonMenu(menuBar);
        this.addPlafMenu(menuBar);
        System.out.println("Adding this");
        this.frame.getContentPane().add(this);
        this.setDirty(false);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FamilyTreeGUI.this.exit();
            }
        });
    }

    @Override
    boolean canEdit() {
        return true;
    }

    private void addFileMenu(JMenuBar menuBar) {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem openItem = new JMenuItem("Open...", 79);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.open();
            }
        });
        fileMenu.add(openItem);
        this.saveItem = new JMenuItem("Save", 83);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.save();
            }
        });
        fileMenu.add(this.saveItem);
        this.saveAsItem = new JMenuItem("Save As...", 65);
        this.saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.saveAs();
            }
        });
        fileMenu.add(this.saveAsItem);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.exit();
            }
        });
        fileMenu.add(exitItem);
    }

    private void addPersonMenu(JMenuBar menuBar) {
        this.personMenu = new JMenu("Person");
        this.personMenu.setMnemonic(80);
        this.personMenu.setEnabled(false);
        menuBar.add(this.personMenu);
        this.fatherItem = new JMenuItem("Father", 70);
        this.fatherItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.displayFather();
            }
        });
        this.personMenu.add(this.fatherItem);
        this.motherItem = new JMenuItem("Mother", 77);
        this.motherItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.displayMother();
            }
        });
        this.personMenu.add(this.motherItem);
        this.personMenu.addSeparator();
        JMenuItem editItem = new JMenuItem("Edit...", 69);
        editItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.editPerson();
            }
        });
        this.personMenu.add(editItem);
        JMenuItem marriageItem = new JMenuItem("Add Marriage...", 77);
        marriageItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FamilyTreeGUI.this.addMarriage();
            }
        });
        this.personMenu.add(marriageItem);
    }

    private void addPlafMenu(JMenuBar menuBar) {
        JMenu plafMenu = new JMenu("Look & Feel");
        plafMenu.setMnemonic(76);
        menuBar.add(plafMenu);
        ButtonGroup bg = new ButtonGroup();
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < infos.length; ++i) {
            final UIManager.LookAndFeelInfo info = infos[i];
            JRadioButtonMenuItem plafItem = info.getName().equals(UIManager.getLookAndFeel().getName()) ? new JRadioButtonMenuItem(info.getName(), true) : new JRadioButtonMenuItem(info.getName(), false);
            plafItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel(info.getClassName());
                        SwingUtilities.updateComponentTreeUI(FamilyTreeGUI.this);
                        FamilyTreeGUI.this.pack();
                    }
                    catch (Exception ex) {
                        FamilyTreeGUI.this.error(ex.toString());
                        return;
                    }
                }
            });
            bg.add(plafItem);
            plafMenu.add(plafItem);
        }
    }

    private void error(String message) {
        JOptionPane.showMessageDialog(this, new String[]{message}, "An error has occurred", 0);
    }

    @Override
    void editPerson() {
        Person person = this.treeList.getSelectedPerson();
        if (person == null) {
            return;
        }
        EditPersonDialog dialog = new EditPersonDialog(person, this.getFrame(), this.tree);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        person = dialog.getPerson();
        if (person != null) {
            this.setDirty(true);
            this.showPerson(person);
            this.treeList.fillInList(this.tree);
        }
    }

    @Override
    void showPerson(Person person) {
        if (person == null) {
            this.personMenu.setEnabled(false);
        } else {
            this.personMenu.setEnabled(true);
            this.motherItem.setEnabled(person.getMother() != null);
            this.fatherItem.setEnabled(person.getFather() != null);
        }
        this.personPanel.showPerson(person);
    }

    @Override
    void newPerson() {
        EditPersonDialog dialog = new EditPersonDialog(this.getFrame(), this.tree);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        Person newPerson = dialog.getPerson();
        if (newPerson != null) {
            this.setDirty(true);
            this.tree.addPerson(newPerson);
            this.treeList.fillInList(this.tree);
        }
    }

    @Override
    void addMarriage() {
        Person person = this.treeList.getSelectedPerson();
        EditMarriageDialog dialog = new EditMarriageDialog(person, this.getFrame(), this.tree);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        Marriage newMarriage = dialog.getMarriage();
        if (newMarriage != null) {
            this.setDirty(true);
            this.showPerson(person);
        }
    }

    private void save() {
        if (this.file == null) {
            this.saveAs();
            return;
        }
        try {
            XmlDumper dumper = new XmlDumper(this.file);
            dumper.dump(this.tree);
            this.setDirty(false);
        }
        catch (IOException ex) {
            this.error("Error while saving family tree: " + ex);
        }
    }

    private JFileChooser getFileChooser() {
        JFileChooser chooser = new JFileChooser();
        if (this.file == null) {
            String cwd = System.getProperty("user.dir");
            chooser.setCurrentDirectory(new File(cwd));
        } else {
            chooser.setCurrentDirectory(this.file.getParentFile());
        }
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName();
                return fileName.endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML files (*.xml)";
            }
        });
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        return chooser;
    }

    private void saveAs() {
        JFileChooser chooser = this.getFileChooser();
        chooser.setDialogTitle("Save As...");
        chooser.setDialogType(1);
        int response = chooser.showSaveDialog(this);
        if (response == 0) {
            this.file = chooser.getSelectedFile();
            if (this.file.exists() && (response = JOptionPane.showConfirmDialog(this, new String[]{"File " + this.file + " already exists.", "Do you want to overwrite it?"}, "Overwrite file?", 0, 3)) == 1) {
                this.saveAs();
                return;
            }
            this.save();
        }
    }

    private void open() {
        if (this.isDirty) {
            int response = JOptionPane.showConfirmDialog(this, new String[]{"You have made changes to your family tree.", "Do you want to save them?"}, "Confirm changes", 1, 3);
            if (response == 0) {
                this.save();
            } else if (response == 2) {
                return;
            }
        }
        JFileChooser chooser = this.getFileChooser();
        chooser.setDialogTitle("Open text file");
        chooser.setDialogType(0);
        int response = chooser.showOpenDialog(this);
        if (response == 0) {
            File file = chooser.getSelectedFile();
            FamilyTree tree = null;
            try {
                XmlParser parser = new XmlParser(file);
                tree = parser.parse();
            }
            catch (FileNotFoundException ex) {
                this.error(ex.toString());
            }
            catch (FamilyTreeException ex) {
                this.error(ex.toString());
            }
            if (tree != null) {
                this.file = file;
                this.sourceLocation.setText(this.file.getName());
                this.tree = tree;
                this.setDirty(false);
                this.treeList.fillInList(this.tree);
                this.sourceLocation.setText(this.file.getPath());
            }
        }
    }

    @Override
    void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.saveAsItem.setEnabled(isDirty);
        this.saveItem.setEnabled(isDirty);
    }

    @Override
    JFrame getFrame() {
        return this.frame;
    }

    private void exit() {
        if (this.isDirty) {
            int response = JOptionPane.showConfirmDialog(this, new String[]{"You have made changes to your family tree.", "Do you want to save them?"}, "Confirm changes", 1, 3);
            if (response == 0) {
                this.save();
                System.exit(0);
            } else if (response == 1) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    public void pack() {
        this.frame.pack();
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.frame.setVisible(isVisible);
    }

    public static void main(String[] args) {
        FamilyTreeGUI gui = new FamilyTreeGUI("Family Tree Program");
        gui.pack();
        gui.setVisible(true);
    }
}

