/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.Person;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JList;

public class FamilyTreeList
extends JList {
    private Map<Integer, Person> indexToPerson = new HashMap<Integer, Person>();

    public FamilyTreeList() {
        this.setSelectionMode(0);
        this.clearSelection();
    }

    public void fillInList(FamilyTree tree) {
        TreeSet<Person> sortedPeople = new TreeSet<Person>(new Comparator<Person>(){

            @Override
            public int compare(Person p1, Person p2) {
                return p1.getId() - p2.getId();
            }

            @Override
            public boolean equals(Object o) {
                return true;
            }
        });
        sortedPeople.addAll(tree.getPeople());
        String[] array = new String[sortedPeople.size()];
        Iterator iter = sortedPeople.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Person person = (Person)iter.next();
            array[i] = person.getFullName() + " (" + person.getId() + ")";
            this.indexToPerson.put(new Integer(i), person);
            ++i;
        }
        this.setListData(array);
        this.clearSelection();
    }

    public Person getSelectedPerson() {
        return this.indexToPerson.get(this.getSelectedIndex());
    }

    public void setSelectedPerson(Person person) {
        Integer index = null;
        for (Map.Entry<Integer, Person> entry : this.indexToPerson.entrySet()) {
            if (!((Object)entry.getValue()).equals(person)) continue;
            index = entry.getKey();
        }
        if (index == null) {
            return;
        }
        this.setSelectedIndex(index);
    }
}

