/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.FamilyTreeList;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PersonPanel;
import edu.pdx.cs.joy.family.XmlParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FamilyTreePanel
extends JPanel {
    protected FamilyTree tree = new FamilyTree();
    protected JLabel sourceLocation;
    protected FamilyTreeList treeList;
    protected PersonPanel personPanel;

    public FamilyTreePanel() {
        this.addComponents();
    }

    void addComponents() {
        System.out.println("Creating Panel");
        Dimension minSizeLeft = new Dimension(50, 100);
        this.treeList = new FamilyTreeList();
        this.treeList.setToolTipText("Click to select a person in the family tree");
        this.treeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Person person = FamilyTreePanel.this.treeList.getSelectedPerson();
                FamilyTreePanel.this.showPerson(person);
            }
        });
        this.treeList.setMinimumSize(minSizeLeft);
        JScrollPane scrollPane = new JScrollPane(this.treeList);
        scrollPane.setMinimumSize(minSizeLeft);
        JPanel newPersonPanel = null;
        if (this.canEdit()) {
            newPersonPanel = new JPanel();
            newPersonPanel.setLayout(new BoxLayout(newPersonPanel, 0));
            newPersonPanel.add(Box.createHorizontalGlue());
            JButton newPersonButton = new JButton("New Person");
            newPersonButton.setToolTipText("Creates a new person");
            newPersonButton.setMnemonic(78);
            newPersonButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FamilyTreePanel.this.newPerson();
                }
            });
            newPersonPanel.add(newPersonButton);
            newPersonPanel.add(Box.createHorizontalGlue());
        }
        JPanel treePanel = new JPanel();
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)scrollPane, "Center");
        if (this.canEdit()) {
            treePanel.add((Component)newPersonPanel, "South");
        }
        this.personPanel = new PersonPanel(this);
        JSplitPane splitPane = new JSplitPane(1, treePanel, this.personPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new BoxLayout(sourcePanel, 0));
        this.sourceLocation = new JLabel();
        this.sourceLocation.setToolTipText("Location of XML file");
        sourcePanel.add(this.sourceLocation);
        sourcePanel.add(Box.createHorizontalGlue());
        Border sourceBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        sourcePanel.setBorder(sourceBorder);
        this.add((Component)sourcePanel, "South");
    }

    void setSourceText(String text) {
        this.sourceLocation.setText(text);
    }

    boolean canEdit() {
        return false;
    }

    void showPerson(Person person) {
        this.personPanel.showPerson(person);
    }

    void displayMother() {
        Person person = this.treeList.getSelectedPerson();
        if (person != null) {
            this.treeList.setSelectedPerson(person.getMother());
        }
    }

    void displayFather() {
        Person person = this.treeList.getSelectedPerson();
        if (person != null) {
            this.treeList.setSelectedPerson(person.getFather());
        }
    }

    FamilyTree getFamilyTree() {
        return this.tree;
    }

    void setDirty(boolean isDirty) {
    }

    void newPerson() {
    }

    void editPerson() {
    }

    void addMarriage() {
    }

    JFrame getFrame() {
        return null;
    }

    protected void setURLSource(URL url) {
        try {
            this.tree = this.parseSource(url);
        }
        catch (IOException ex) {
            System.out.println("source = " + this.sourceLocation + ": " + ex);
            this.sourceLocation.setText(ex.toString());
            return;
        }
        catch (FamilyTreeException ex) {
            this.sourceLocation.setText(ex.toString());
            return;
        }
        this.treeList.fillInList(this.tree);
        this.sourceLocation.setText(url.toExternalForm());
    }

    protected FamilyTree parseSource(URL url) throws IOException, FamilyTreeException {
        InputStream stream = url.openStream();
        XmlParser parser = new XmlParser(new InputStreamReader(stream));
        return parser.parse();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("** No URL Specified!!");
            System.exit(1);
        }
        URL url = null;
        try {
            url = new URL(args[0]);
        }
        catch (MalformedURLException ex) {
            System.err.println(ex.toString());
            System.exit(1);
        }
        FamilyTreePanel viewer = new FamilyTreePanel();
        viewer.setURLSource(url);
        JFrame frame = new JFrame("Family Tree Panel");
        frame.getContentPane().add(viewer);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

