/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.RemoteFamilyTree;
import edu.pdx.cs.joy.family.RemotePerson;
import java.io.PrintStream;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

public class GetLiving {
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: java GetLiving familyName host port");
        err.println("  -date Date");
        err.println("");
        err.println("This program queries a remote family tree to determine which people are alive.");
        err.println("");
        err.println("Dates should be in the form MM/DD/YYYY");
        err.println("");
        System.exit(1);
    }

    public static void main(String[] args) {
        String familyName = null;
        String host = null;
        int port = -1;
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-date")) {
                if (++i >= args.length) {
                    GetLiving.usage("Missing date");
                }
                try {
                    date = df.parse(args[i]);
                }
                catch (ParseException ex) {
                    GetLiving.usage("Malformed date: " + args[i]);
                }
                continue;
            }
            if (familyName == null) {
                familyName = args[i];
                continue;
            }
            if (host == null) {
                host = args[i];
                continue;
            }
            if (port == -1) {
                try {
                    port = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    GetLiving.usage("Invalid port: " + args[i]);
                }
                continue;
            }
            GetLiving.usage("Spurious command line: " + args[i]);
        }
        if (familyName == null) {
            GetLiving.usage("Missing family name");
        } else if (host == null) {
            GetLiving.usage("Missing host");
        } else if (port == -1) {
            GetLiving.usage("Missing port");
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        String name = "rmi://" + host + ":" + port + "/" + familyName;
        try {
            RemoteFamilyTree tree = (RemoteFamilyTree)Naming.lookup(name);
            if (date != null) {
                Collection<RemotePerson> living = tree.getLiving(date);
                out.println("\n" + living.size() + " people were alive on " + df.format(date) + "\n");
                for (RemotePerson person : living) {
                    out.println(person.getDescription());
                    out.println("");
                }
            } else {
                Collection<RemotePerson> living = tree.getLiving();
                out.println("\n" + living.size() + " people are alive\n");
                for (RemotePerson person : living) {
                    out.println(person.getDescription());
                    out.println("");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
        }
    }
}

