/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.Dumper;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Parser;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.TextDumper;
import edu.pdx.cs.joy.family.TextParser;
import edu.pdx.cs.joy.family.XmlDumper;
import edu.pdx.cs.joy.family.XmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class NoteMarriage {
    private static PrintWriter err = new PrintWriter(System.err, true);
    private static int husbandId = 0;
    private static int wifeId = 0;
    private static Date date;
    private static String location;
    private static String fileName;
    private static boolean useXml;

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("Makes note of a marriage between two people");
        err.println("usage: java NoteMarriage [options] <args>");
        err.println("  args are (in this order):");
        err.println("    file                File containing family info");
        err.println("    husbandId           The id of the husband");
        err.println("    wifeId              The id of the wife");
        err.println("  options are (options may appear in any order):");
        err.println("    -date date          Date marriage took place");
        err.println("    -location string    Where marriage took place");
        err.println("    -xml                File in XML format");
        err.println("\n");
        System.exit(1);
    }

    private static String parseCommandLine(String[] args) {
        DateFormat df = DateFormat.getDateInstance(2);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-xml")) {
                useXml = true;
                continue;
            }
            if (args[i].equals("-date")) {
                if (++i >= args.length) {
                    return "Missing marriage date";
                }
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < 3; ++j) {
                    if (i >= args.length) {
                        return "Malformatted date of birth: " + sb;
                    }
                    sb.append(args[i] + " ");
                    ++i;
                }
                --i;
                try {
                    date = df.parse(sb.toString().trim());
                    continue;
                }
                catch (ParseException ex) {
                    return "Malformatted marriage date: " + args[i];
                }
            }
            if (args[i].equals("-location")) {
                if (++i >= args.length) {
                    return "Missing marriage location";
                }
                location = args[i];
                continue;
            }
            if (fileName == null) {
                fileName = args[i];
                continue;
            }
            if (husbandId == 0) {
                try {
                    husbandId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    return "Malformatted husband id: " + args[i];
                }
                if (husbandId >= 1) continue;
                return "Illegal husband id value: " + husbandId;
            }
            if (wifeId == 0) {
                try {
                    wifeId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    return "Malformatted wife id: " + args[i];
                }
                if (wifeId >= 1) continue;
                return "Illegal wife id value: " + husbandId;
            }
            return "Unknown command line option: " + args[i];
        }
        if (husbandId == 0) {
            return "No husband id specified";
        }
        if (wifeId == 0) {
            return "No wife id specified";
        }
        if (fileName == null) {
            return "No file specified";
        }
        return null;
    }

    public static void main(String[] args) {
        String message = NoteMarriage.parseCommandLine(args);
        if (message != null) {
            NoteMarriage.usage(message);
        }
        FamilyTree tree = null;
        File file = new File(fileName);
        if (file.exists()) {
            Parser parser = null;
            if (useXml) {
                try {
                    parser = new XmlParser(file);
                }
                catch (FileNotFoundException ex) {
                    err.println("** Could not find file " + fileName);
                    System.exit(1);
                }
            } else {
                try {
                    parser = new TextParser(file);
                }
                catch (FileNotFoundException ex) {
                    err.println("** Could not find file " + fileName);
                    System.exit(1);
                }
            }
            try {
                tree = parser.parse();
            }
            catch (FamilyTreeException ex) {
                err.println("** File " + fileName + " is malformatted");
                System.exit(1);
            }
        } else {
            tree = new FamilyTree();
        }
        Person husband = tree.getPerson(husbandId);
        Person wife = tree.getPerson(wifeId);
        Marriage marriage = new Marriage(husband, wife);
        husband.addMarriage(marriage);
        wife.addMarriage(marriage);
        if (location != null) {
            marriage.setLocation(location);
        }
        if (date != null) {
            marriage.setDate(date);
        }
        Dumper dumper = null;
        if (useXml) {
            try {
                dumper = new XmlDumper(file);
            }
            catch (IOException ex) {
                err.println("** Error while dealing with " + file);
                System.exit(1);
            }
        } else {
            try {
                dumper = new TextDumper(file);
            }
            catch (IOException ex) {
                err.println("** Error while dealing with " + file);
                System.exit(1);
            }
        }
        dumper.dump(tree);
    }

    static {
        useXml = false;
    }
}

