/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Marriage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class Person
implements Serializable {
    public static Gender MALE = Gender.MALE;
    public static Gender FEMALE = Gender.FEMALE;
    public static final int UNKNOWN = -1;
    private int id;
    private Gender gender;
    private String firstName;
    private String middleName;
    private String lastName;
    private Person father;
    private Person mother;
    private Collection<Marriage> marriages;
    private Date dob;
    private Date dod;
    private int motherId = -1;
    private int fatherId = -1;

    public Person(int id, Gender gender) {
        if (id < 1) {
            String m = "A person's id must be greater than 1: " + id;
            throw new FamilyTreeException(m);
        }
        if (gender != MALE && gender != FEMALE) {
            String s = "Gender must be MALE or FEMALE";
            throw new FamilyTreeException(s);
        }
        this.id = id;
        this.gender = gender;
        this.marriages = new ArrayList<Marriage>();
    }

    Person(int id) {
        if (id < 1) {
            String m = "A person's id must be greater than 1: " + id;
            throw new FamilyTreeException(m);
        }
        this.id = id;
        this.gender = Gender.UNKNOWN;
        this.marriages = new ArrayList<Marriage>();
    }

    private Person() {
    }

    public int getId() {
        return this.id;
    }

    void setGender(Gender gender) {
        if (gender != MALE && gender != FEMALE) {
            String s = "Invalid gender: " + gender;
            throw new FamilyTreeException(s);
        }
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFullName() {
        StringBuffer fullName = new StringBuffer();
        if (this.firstName != null) {
            fullName.append(this.firstName);
            fullName.append(' ');
        }
        if (this.middleName != null) {
            fullName.append(this.middleName);
            fullName.append(' ');
        }
        if (this.lastName != null) {
            fullName.append(this.lastName);
        }
        return fullName.toString().trim();
    }

    public void setFather(Person father) {
        if (father.getGender() != MALE) {
            String s = "Father " + father + " must be MALE";
            throw new FamilyTreeException(s);
        }
        this.fatherId = father.getId();
        this.father = father;
    }

    public int getFatherId() {
        if (this.father == null) {
            return -1;
        }
        return this.father.getId();
    }

    public Person getFather() {
        return this.father;
    }

    void setFatherId(int id) {
        this.fatherId = id;
    }

    public void setMother(Person mother) {
        if (mother.getGender() != FEMALE) {
            String s = "Person " + mother.getId() + "(mother of " + this.getId() + ") must be FEMALE";
            throw new FamilyTreeException(s);
        }
        this.mother = mother;
    }

    public int getMotherId() {
        if (this.mother == null) {
            return -1;
        }
        return this.mother.getId();
    }

    public Person getMother() {
        return this.mother;
    }

    void setMotherId(int id) {
        this.motherId = id;
    }

    void patchUp(FamilyTree tree) {
        if (this.father == null && this.fatherId != -1) {
            Person father = tree.getPerson(this.fatherId);
            if (father == null) {
                String s = "Father " + this.fatherId + " does not exist";
                throw new FamilyTreeException(s);
            }
            this.setFather(father);
        }
        if (this.mother == null && this.motherId != -1) {
            Person mother = tree.getPerson(this.motherId);
            if (mother == null) {
                String s = "Mother " + this.motherId + " does not exist";
                throw new FamilyTreeException(s);
            }
            this.setMother(mother);
        }
        if (this.gender == Gender.UNKNOWN) {
            String s = "Gender has not been set yet!";
            throw new FamilyTreeException(s);
        }
    }

    public void setDateOfBirth(Date dob) {
        this.dob = dob;
    }

    public Date getDateOfBirth() {
        return this.dob;
    }

    public void setDateOfDeath(Date dod) {
        if (this.dob != null && dod != null && this.dob.after(dod)) {
            String s = "Date of death (" + dod + ") cannot occur before date of birth (" + this.dob + ")";
            throw new FamilyTreeException(s);
        }
        this.dod = dod;
    }

    public Date getDateOfDeath() {
        return this.dod;
    }

    public void addMarriage(Marriage marriage) {
        if (this.getGender() == MALE) {
            if (!marriage.getHusband().equals(this)) {
                String s = "This person (" + this.getFullName() + ") is not the husband in " + marriage;
                throw new FamilyTreeException(s);
            }
        } else if (!marriage.getWife().equals(this)) {
            String s = "This person (" + this.getFullName() + ") is not the wife in " + marriage;
            throw new FamilyTreeException(s);
        }
        this.marriages.add(marriage);
    }

    public Collection<Marriage> getMarriages() {
        return this.marriages;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person other = (Person)o;
        return this.getId() == other.getId();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Person ").append(this.id).append(": ").append(this.getFullName());
        if (this.dob != null) {
            sb.append("\nBorn: ");
            sb.append(this.dob);
        }
        if (this.dod != null) {
            sb.append(", Died: ");
            sb.append(this.dod);
        }
        if (this.mother != null) {
            sb.append("\nMother: ");
            sb.append(this.mother.getFullName());
        }
        if (this.father != null) {
            sb.append(", Father: ");
            sb.append(this.father.getFullName());
        }
        sb.append("\nMarried ");
        sb.append(this.marriages.size());
        sb.append(" times");
        return sb.toString();
    }

    public static enum Gender {
        FEMALE,
        MALE,
        UNKNOWN;

    }
}

