/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.EditMarriageDialog;
import edu.pdx.cs.joy.family.FamilyTreePanel;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Person;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class PersonPanel
extends JPanel {
    private FamilyTreePanel familyGUI;
    private Person person;
    private ArrayList<Marriage> marriages = new ArrayList();
    private JLabel name;
    private JLabel dob;
    private JLabel dod;
    private JLabel fatherName;
    private JLabel motherName;
    private JList marriagesList;

    public PersonPanel(final FamilyTreePanel familyGUI) {
        this.familyGUI = familyGUI;
        this.setLayout(new BoxLayout(this, 1));
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        this.name = new JLabel("Name: ");
        this.name.setToolTipText("The name of this person");
        this.name.setAlignmentX(0.0f);
        infoPanel.add(this.name);
        this.dob = new JLabel("Born: ");
        this.dob.setToolTipText("The day this person was born");
        this.dob.setAlignmentX(0.0f);
        infoPanel.add(this.dob);
        this.dod = new JLabel("Died: ");
        this.dod.setToolTipText("The day this person died");
        this.dod.setAlignmentX(0.0f);
        infoPanel.add(this.dod);
        this.fatherName = new JLabel("Father: ");
        this.fatherName.setToolTipText("Click to view this person's father");
        this.fatherName.setAlignmentX(0.0f);
        this.fatherName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PersonPanel.this.familyGUI.displayFather();
            }
        });
        infoPanel.add(this.fatherName);
        this.motherName = new JLabel("Mother: ");
        this.motherName.setToolTipText("Click to view this person's mother");
        this.motherName.setAlignmentX(0.0f);
        this.motherName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PersonPanel.this.familyGUI.displayMother();
            }
        });
        infoPanel.add(this.motherName);
        Border infoBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        infoPanel.setBorder(infoBorder);
        this.add(infoPanel);
        JPanel marriagePanel = new JPanel();
        marriagePanel.setToolTipText("The marriages this person is involed in");
        marriagePanel.setLayout(new BoxLayout(marriagePanel, 1));
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Marriages"), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        marriagePanel.setBorder(border);
        this.marriagesList = new JList();
        this.marriagesList.setMinimumSize(new Dimension(100, 30));
        this.marriagesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = PersonPanel.this.marriagesList.getSelectedIndex();
                    Marriage marriage = null;
                    if (index < PersonPanel.this.marriages.size()) {
                        marriage = PersonPanel.this.marriages.get(index);
                    }
                    if (marriage != null && familyGUI.canEdit()) {
                        EditMarriageDialog dialog = new EditMarriageDialog(marriage, familyGUI.getFrame(), familyGUI.getFamilyTree());
                        dialog.pack();
                        dialog.setLocationRelativeTo(familyGUI);
                        dialog.setVisible(true);
                        if (dialog.getMarriage() != null) {
                            familyGUI.setDirty(true);
                            familyGUI.showPerson(PersonPanel.this.person);
                        }
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.marriagesList);
        marriagePanel.add(scrollPane);
        if (familyGUI.canEdit()) {
            JButton addMarriageButton = new JButton("Add Marriage");
            addMarriageButton.setToolTipText("Notes a marriage involving this person");
            addMarriageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PersonPanel.this.familyGUI.addMarriage();
                }
            });
            JPanel addMarriagePanel = new JPanel();
            addMarriagePanel.setLayout(new BoxLayout(addMarriagePanel, 0));
            addMarriagePanel.add(Box.createHorizontalGlue());
            addMarriagePanel.add(addMarriageButton);
            marriagePanel.add(addMarriagePanel);
            marriagePanel.setAlignmentX(0.0f);
            this.add(marriagePanel);
            JPanel editPanel = new JPanel();
            JButton editButton = new JButton("Edit");
            editButton.setToolTipText("Click to edit this person");
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PersonPanel.this.familyGUI.editPerson();
                }
            });
            editPanel.setLayout(new BoxLayout(editPanel, 0));
            editPanel.add(Box.createHorizontalGlue());
            editPanel.add(editButton);
            editPanel.add(Box.createHorizontalGlue());
            editPanel.setAlignmentX(0.0f);
            this.add(editPanel);
        }
        this.add(Box.createVerticalGlue());
    }

    private void fillInLabels() {
        this.name.setText("Name");
        this.dob.setText("Born:");
        this.dod.setText("Died:");
        this.fatherName.setText("Father:");
        this.motherName.setText("Mother:");
        this.marriagesList.setListData(new Vector());
    }

    public void showPerson(Person person) {
        Person mother;
        Person father;
        Date dod;
        this.person = person;
        this.fillInLabels();
        if (this.person == null) {
            return;
        }
        DateFormat df = DateFormat.getDateInstance(1);
        this.name.setText(person.getFullName());
        Date dob = person.getDateOfBirth();
        if (dob != null) {
            this.dob.setText("Born: " + df.format(dob));
        }
        if ((dod = person.getDateOfDeath()) != null) {
            this.dod.setText("Died: " + df.format(dod));
        }
        if ((father = person.getFather()) != null) {
            this.fatherName.setText("Father: " + father.getFullName());
        }
        if ((mother = person.getMother()) != null) {
            this.motherName.setText("Mother: " + mother.getFullName());
        }
        this.marriages = new ArrayList<Marriage>(person.getMarriages());
        Vector<String> list = new Vector<String>();
        for (Marriage marriage : person.getMarriages()) {
            String location;
            StringBuffer sb = new StringBuffer();
            Person spouse = marriage.getHusband().getId() == person.getId() ? marriage.getWife() : marriage.getHusband();
            sb.append(spouse.getFullName());
            Date date = marriage.getDate();
            if (date != null) {
                sb.append(" on " + df.format(date));
            }
            if ((location = marriage.getLocation()) != null || !location.equals("")) {
                sb.append(" in " + location);
            }
            list.add(sb.toString());
        }
        this.marriagesList.setListData(list);
    }

    public Person showFather() {
        Person father = this.person.getFather();
        if (father != null) {
            this.showPerson(father);
        }
        return father;
    }

    public Person showMother() {
        Person mother = this.person.getMother();
        if (mother != null) {
            this.showPerson(mother);
        }
        return mother;
    }
}

