/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.Dumper;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PersonMain;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;

public class PrettyPrinter
implements Dumper {
    private PrintWriter pw;

    public PrettyPrinter(String fileName) throws IOException {
        this(new File(fileName));
    }

    public PrettyPrinter(File file) throws IOException {
        this(new PrintWriter((Writer)new FileWriter(file), true));
    }

    PrettyPrinter(PrintWriter pw) {
        this.pw = pw;
    }

    @Override
    public void dump(FamilyTree tree) {
        TreeSet<Person> sortedTree = new TreeSet<Person>(new PersonSorter());
        sortedTree.addAll(tree.getPeople());
        this.pw.println("Your Family Tree\n");
        DateFormat df = DateFormat.getDateInstance(1);
        for (Person person : sortedTree) {
            Person father;
            Person mother;
            Date dod;
            this.pw.println("Person " + person.getId() + ": " + person.getFullName());
            Date dob = person.getDateOfBirth();
            if (dob != null) {
                this.pw.print("  Born on " + df.format(dob));
            }
            if ((dod = person.getDateOfDeath()) != null) {
                this.pw.print(", died on " + df.format(dod));
            }
            if (dob != null || dod != null) {
                this.pw.println("");
            }
            if ((mother = person.getMother()) != null) {
                this.pw.println("  Mother: " + mother.getFullName() + " (" + mother.getId() + ")");
            }
            if ((father = person.getFather()) != null) {
                this.pw.println("  Father: " + father.getFullName() + " (" + father.getId() + ")");
            }
            for (Marriage marriage : person.getMarriages()) {
                String location;
                Person spouse = marriage.getWife().equals(person) ? marriage.getHusband() : marriage.getWife();
                this.pw.print("  Married " + spouse.getFullName());
                Date date = marriage.getDate();
                if (date != null) {
                    this.pw.print(" on " + df.format(date));
                }
                if ((location = marriage.getLocation()) != null) {
                    this.pw.print(" in " + location);
                }
                this.pw.println("");
            }
            this.pw.println("");
        }
        this.pw.flush();
        this.pw.close();
    }

    public static void main(String[] args) {
        Person me = PersonMain.me();
        Person mom = PersonMain.mom(me);
        Person dad = PersonMain.dad(me);
        me.setMother(mom);
        me.setFather(dad);
        Marriage marriage = new Marriage(dad, mom);
        marriage.setLocation("Durham, NH");
        try {
            DateFormat df = DateFormat.getDateInstance(2);
            marriage.setDate(df.parse("Jul 12, 1969"));
        }
        catch (ParseException ex) {
            System.out.println("** Malformed marriage date?");
            System.exit(1);
        }
        mom.addMarriage(marriage);
        dad.addMarriage(marriage);
        FamilyTree tree = new FamilyTree();
        tree.addPerson(dad);
        tree.addPerson(mom);
        tree.addPerson(me);
        PrintWriter out = new PrintWriter(System.out, true);
        PrettyPrinter pretty = new PrettyPrinter(out);
        pretty.dump(tree);
    }

    class PersonSorter
    implements Comparator<Person> {
        PersonSorter() {
        }

        @Override
        public int compare(Person p1, Person p2) {
            return p1.getId() - p2.getId();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof PersonSorter;
        }
    }
}

