/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.RemoteFamilyTree;
import edu.pdx.cs.joy.family.RemotePerson;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;

class RemotePersonImpl
extends UnicastRemoteObject
implements RemotePerson {
    private transient Person person;
    private transient RemoteFamilyTree tree;

    RemotePersonImpl(RemoteFamilyTree tree, Person person) throws RemoteException {
        this.tree = tree;
        this.person = person;
    }

    @Override
    public int getId() throws RemoteException {
        return this.person.getId();
    }

    @Override
    public Person.Gender getGender() throws RemoteException {
        return this.person.getGender();
    }

    @Override
    public String getFirstName() throws RemoteException {
        return this.person.getFirstName();
    }

    @Override
    public void setFirstName(String firstName) throws RemoteException {
        this.person.setFirstName(firstName);
    }

    @Override
    public String getMiddleName() throws RemoteException {
        return this.person.getMiddleName();
    }

    @Override
    public void setMiddleName(String middleName) throws RemoteException {
        this.person.setMiddleName(middleName);
    }

    @Override
    public String getLastName() throws RemoteException {
        return this.person.getLastName();
    }

    @Override
    public void setLastName(String lastName) throws RemoteException {
        this.person.setLastName(lastName);
    }

    @Override
    public int getFatherId() throws RemoteException {
        return this.person.getFatherId();
    }

    @Override
    public void setFatherId(int fatherId) throws RemoteException {
        RemotePersonImpl rPerson = (RemotePersonImpl)this.tree.getPerson(fatherId);
        if (rPerson == null) {
            String s = "Could not find person with id " + fatherId;
            throw new FamilyTreeException(s);
        }
        this.person.setFather(rPerson.person);
    }

    @Override
    public int getMotherId() throws RemoteException {
        return this.person.getMotherId();
    }

    @Override
    public void setMotherId(int motherId) throws RemoteException {
        RemotePersonImpl rPerson = (RemotePersonImpl)this.tree.getPerson(motherId);
        if (rPerson == null) {
            String s = "Could not find person with id " + motherId;
            throw new FamilyTreeException(s);
        }
        this.person.setMother(rPerson.person);
    }

    @Override
    public Date getDateOfBirth() throws RemoteException {
        return this.person.getDateOfBirth();
    }

    @Override
    public void setDateOfBirth(Date dob) throws RemoteException {
        this.person.setDateOfBirth(dob);
    }

    @Override
    public Date getDateOfDeath() throws RemoteException {
        return this.person.getDateOfDeath();
    }

    @Override
    public void setDateOfDeath(Date dod) throws RemoteException {
        this.person.setDateOfDeath(dod);
    }

    @Override
    public String getDescription() throws RemoteException {
        return this.person.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RemotePerson) {
            RemotePerson other = (RemotePerson)o;
            try {
                return this.getId() == other.getId();
            }
            catch (RemoteException ex) {
                return false;
            }
        }
        return false;
    }
}

