/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.Dumper;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PersonMain;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;

public class TextDumper
implements Dumper {
    private PrintWriter pw;

    public TextDumper(String fileName) throws IOException {
        this(new File(fileName));
    }

    public TextDumper(File file) throws IOException {
        this(new PrintWriter((Writer)new FileWriter(file), true));
    }

    public TextDumper(PrintWriter pw) {
        this.pw = pw;
    }

    @Override
    public void dump(FamilyTree tree) {
        StringBuffer data;
        int lines;
        HashSet<Marriage> marriages = new HashSet<Marriage>();
        DateFormat df = DateFormat.getDateInstance(2);
        for (Person person : tree.getPeople()) {
            Date dod;
            Date dob;
            Person father;
            Person mother;
            String lastName;
            String middleName;
            lines = 0;
            data = new StringBuffer();
            data.append("id: " + person.getId() + "\n");
            ++lines;
            data.append("g: " + person.getGender() + "\n");
            ++lines;
            String firstName = person.getFirstName();
            if (firstName != null) {
                data.append("fn: " + firstName + "\n");
                ++lines;
            }
            if ((middleName = person.getMiddleName()) != null) {
                data.append("mn: " + middleName + "\n");
                ++lines;
            }
            if ((lastName = person.getLastName()) != null) {
                data.append("ln: " + lastName + "\n");
                ++lines;
            }
            if ((mother = person.getMother()) != null) {
                data.append("m: " + mother.getId() + "\n");
                ++lines;
            }
            if ((father = person.getFather()) != null) {
                data.append("f: " + father.getId() + "\n");
                ++lines;
            }
            if ((dob = person.getDateOfBirth()) != null) {
                data.append("dob: " + df.format(dob) + "\n");
                ++lines;
            }
            if ((dod = person.getDateOfDeath()) != null) {
                data.append("dod: " + df.format(dod) + "\n");
                ++lines;
            }
            marriages.addAll(person.getMarriages());
            this.pw.println("P " + lines);
            this.pw.print(data.toString());
        }
        for (Marriage marriage : marriages) {
            Date date;
            lines = 0;
            data = new StringBuffer();
            data.append(marriage.getHusband().getId() + " " + marriage.getWife().getId() + "\n");
            ++lines;
            String location = marriage.getLocation();
            if (location != null) {
                data.append("l: " + location + "\n");
                ++lines;
            }
            if ((date = marriage.getDate()) != null) {
                data.append("d: " + df.format(date) + "\n");
                ++lines;
            }
            this.pw.println("M " + lines);
            this.pw.print(data.toString());
        }
        this.pw.flush();
        this.pw.close();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("** No file specified");
            System.exit(1);
        }
        String fileName = args[0];
        Person me = PersonMain.me();
        Person mom = PersonMain.mom(me);
        Person dad = PersonMain.dad(me);
        me.setMother(mom);
        me.setFather(dad);
        Marriage marriage = new Marriage(dad, mom);
        marriage.setLocation("Durham, NH");
        try {
            DateFormat df = DateFormat.getDateInstance(2);
            marriage.setDate(df.parse("Jul 12, 1969"));
        }
        catch (ParseException ex) {
            System.out.println("** Malformed marriage date?");
            System.exit(1);
        }
        mom.addMarriage(marriage);
        dad.addMarriage(marriage);
        FamilyTree tree = new FamilyTree();
        tree.addPerson(dad);
        tree.addPerson(mom);
        tree.addPerson(me);
        try {
            TextDumper dumper = new TextDumper(fileName);
            dumper.dump(tree);
        }
        catch (IOException ex) {
            System.err.println("** IOException while dealing with " + fileName);
            System.exit(1);
        }
    }
}

