/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Parser;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PrettyPrinter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.StringTokenizer;

public class TextParser
implements Parser {
    private LineNumberReader in;
    private FamilyTree tree;
    private static final PrintStream out = System.out;

    private static void db(String s) {
        if (Boolean.getBoolean("TextParser.DEBUG")) {
            out.println(s);
        }
    }

    public TextParser(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public TextParser(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public TextParser(Reader reader) {
        this.in = new LineNumberReader(reader);
    }

    private void error(String message) throws FamilyTreeException {
        int lineNumber = this.in.getLineNumber();
        String m = "Error at line " + lineNumber + ": " + message;
        throw new FamilyTreeException(m);
    }

    @Override
    public FamilyTree parse() throws FamilyTreeException {
        this.tree = new FamilyTree();
        block4: while (true) {
            try {
                String line;
                while (this.in.ready() && (line = this.in.readLine()) != null) {
                    if (line.equals("")) continue;
                    TextParser.db("Read line: \"" + line + "\"");
                    String type = null;
                    String nLines = null;
                    StringTokenizer st = new StringTokenizer(line, " ");
                    if (st.hasMoreTokens()) {
                        type = st.nextToken();
                    } else {
                        this.error("Missing type token in header");
                    }
                    if (st.hasMoreTokens()) {
                        nLines = st.nextToken();
                    } else {
                        this.error("Missing line count in header");
                    }
                    try {
                        int n = Integer.parseInt(nLines);
                        if (type.equals("P")) {
                            this.parsePerson(n);
                            continue block4;
                        }
                        if (type.equals("M")) {
                            this.parseMarriage(n);
                            continue block4;
                        }
                        this.error("Invalid type string: " + type);
                        continue block4;
                    }
                    catch (NumberFormatException ex) {
                        this.error("Malformatted line count: " + nLines);
                    }
                }
                break;
            }
            catch (IOException ex) {
                int lineNumber = this.in.getLineNumber();
                String m = "Parsing error at line " + lineNumber;
                throw new FamilyTreeException(m);
            }
        }
        for (Person person : this.tree.getPeople()) {
            person.patchUp(this.tree);
        }
        return this.tree;
    }

    private void parsePerson(int nLines) throws FamilyTreeException {
        Person person = null;
        DateFormat df = DateFormat.getDateInstance(2);
        for (int i = 0; i < nLines; ++i) {
            String line = null;
            try {
                if (!this.in.ready()) {
                    this.error("Unexpected end of file");
                }
                line = this.in.readLine();
            }
            catch (IOException ex) {
                this.error("IOException: " + ex.getMessage());
            }
            if (line == null) break;
            if (line.equals("")) continue;
            TextParser.db("Read line: \"" + line + "\"");
            String key = null;
            String value = null;
            StringTokenizer st = new StringTokenizer(line, ":");
            if (st.hasMoreTokens()) {
                key = st.nextToken();
            } else {
                this.error("No key specified");
            }
            if (st.hasMoreTokens()) {
                StringBuffer sb = new StringBuffer();
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken() + " ");
                }
                value = sb.toString().trim();
            } else {
                this.error("No value specified");
            }
            if (key.equals("id")) {
                try {
                    int id = Integer.parseInt(value);
                    if (this.tree.getPerson(id) != null) {
                        this.error("FamilyTree already has person " + id);
                        continue;
                    }
                    person = new Person(id);
                    this.tree.addPerson(person);
                }
                catch (NumberFormatException ex) {
                    this.error("Malformatted id: " + value);
                }
                continue;
            }
            if (key.equals("g")) {
                if (person != null) {
                    try {
                        Person.Gender gender = Person.Gender.valueOf(value);
                        person.setGender(gender);
                        TextParser.db("Set gender of " + person + " to " + gender);
                    }
                    catch (IllegalArgumentException ex) {
                        this.error("Malformed gender: " + value);
                    }
                    continue;
                }
                this.error("Id must be specified before gender");
                continue;
            }
            if (key.equals("fn")) {
                if (person != null) {
                    person.setFirstName(value);
                    continue;
                }
                this.error("Id must be specified before first name");
                continue;
            }
            if (key.equals("mn")) {
                if (person != null) {
                    person.setMiddleName(value);
                    continue;
                }
                this.error("Id must be specified before middle name");
                continue;
            }
            if (key.equals("ln")) {
                if (person != null) {
                    person.setLastName(value);
                    continue;
                }
                this.error("Id must be specified before last name");
                continue;
            }
            if (key.equals("f")) {
                if (person != null) {
                    try {
                        int fatherId = Integer.parseInt(value);
                        person.setFatherId(fatherId);
                    }
                    catch (NumberFormatException ex) {
                        this.error("Malformatted father id: " + value);
                    }
                    continue;
                }
                this.error("Id must be specified before father");
                continue;
            }
            if (key.equals("m")) {
                if (person != null) {
                    try {
                        int motherId = Integer.parseInt(value);
                        person.setMotherId(motherId);
                    }
                    catch (NumberFormatException ex) {
                        this.error("Malformatted mother id: " + value);
                    }
                    continue;
                }
                this.error("Id must be specified before mother");
                continue;
            }
            if (key.equals("dob")) {
                if (person != null) {
                    try {
                        person.setDateOfBirth(df.parse(value));
                    }
                    catch (ParseException ex) {
                        this.error("Malformatted date of birth: " + value);
                    }
                    continue;
                }
                this.error("Id must be specified before date of birth");
                continue;
            }
            if (key.equals("dod")) {
                if (person != null) {
                    try {
                        person.setDateOfDeath(df.parse(value));
                    }
                    catch (ParseException ex) {
                        this.error("Malformatted date of death: " + value);
                    }
                    continue;
                }
                this.error("Id must be specified before date of death");
                continue;
            }
            this.error("Unknown person key: " + key);
        }
    }

    private void parseMarriage(int nLines) throws FamilyTreeException {
        String s;
        Marriage marriage = null;
        DateFormat df = DateFormat.getDateInstance(2);
        if (nLines < 1) {
            this.error("Missing ids in marriage");
        }
        String line = null;
        try {
            if (!this.in.ready()) {
                this.error("Unexpected end of file");
            }
            line = this.in.readLine();
        }
        catch (IOException ex) {
            this.error("IOException: " + ex.getMessage());
        }
        Person husband = null;
        Person wife = null;
        StringTokenizer st = new StringTokenizer(line, " ");
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            try {
                int husbandId = Integer.parseInt(s);
                husband = this.tree.getPerson(husbandId);
            }
            catch (NumberFormatException ex) {
                this.error("Malformatted husband id: " + s);
            }
        } else {
            this.error("Missing husband id");
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            try {
                int wifeId = Integer.parseInt(s);
                wife = this.tree.getPerson(wifeId);
            }
            catch (NumberFormatException ex) {
                this.error("Malformatted wife id: " + s);
            }
        } else {
            this.error("Missing wife id");
        }
        marriage = new Marriage(husband, wife);
        wife.addMarriage(marriage);
        husband.addMarriage(marriage);
        for (int i = 1; i < nLines; ++i) {
            line = null;
            try {
                if (!this.in.ready()) {
                    this.error("Unexpected end of file");
                }
                line = this.in.readLine();
            }
            catch (IOException ex) {
                this.error("IOException: " + ex.getMessage());
            }
            if (line.equals("")) continue;
            String key = null;
            String value = null;
            st = new StringTokenizer(line, ":");
            if (st.hasMoreTokens()) {
                key = st.nextToken();
            } else {
                this.error("No key specified");
            }
            if (st.hasMoreTokens()) {
                StringBuffer sb = new StringBuffer();
                while (st.hasMoreTokens()) {
                    sb.append(st.nextToken() + " ");
                }
                value = sb.toString().trim();
            } else {
                this.error("No value specified for key " + key);
            }
            if (key.equals("d")) {
                try {
                    marriage.setDate(df.parse(value));
                }
                catch (ParseException ex) {
                    this.error("Malformatted marriage date: " + value);
                }
                continue;
            }
            if (key.equals("l")) {
                marriage.setLocation(value);
                continue;
            }
            this.error("Unknown marriage key: " + key);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("** Missing file name");
            System.exit(1);
        }
        String fileName = args[0];
        try {
            TextParser parser = new TextParser(fileName);
            FamilyTree tree = parser.parse();
            PrintWriter out = new PrintWriter(System.out, true);
            PrettyPrinter pretty = new PrettyPrinter(out);
            pretty.dump(tree);
        }
        catch (FileNotFoundException ex) {
            System.err.println("** Could not find file " + fileName);
        }
        catch (FamilyTreeException ex) {
            System.err.println("** " + ex.getMessage());
        }
    }
}

