/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.RemoteFamilyTree;
import edu.pdx.cs.joy.family.RemoteMarriage;
import java.io.PrintStream;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UpdateMarriage {
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: java UpdateMarriage familyName host port husbandId wifeId");
        err.println("  -date Date");
        err.println("  -location Location");
        err.println("");
        err.println("This program updates the information about a marriage between two people in a remote family tree.");
        err.println("If the marriage does not already exist, a new person will be created.");
        err.println("");
        err.println("Dates should be in the form MM/DD/YYYY");
        err.println("");
        System.exit(1);
    }

    public static void main(String[] args) {
        String familyName = null;
        String host = null;
        int port = -1;
        int husbandId = -1;
        int wifeId = -1;
        Date date = null;
        String location = null;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-date")) {
                if (++i >= args.length) {
                    UpdateMarriage.usage("Missing date");
                }
                try {
                    date = df.parse(args[i]);
                }
                catch (ParseException ex) {
                    UpdateMarriage.usage("Malformed date: " + args[i]);
                }
                continue;
            }
            if (args[i].equals("-location")) {
                if (++i >= args.length) {
                    UpdateMarriage.usage("Missing location");
                }
                location = args[i];
                continue;
            }
            if (familyName == null) {
                familyName = args[i];
                continue;
            }
            if (host == null) {
                host = args[i];
                continue;
            }
            if (port == -1) {
                try {
                    port = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    UpdateMarriage.usage("Invalid port: " + args[i]);
                }
                continue;
            }
            if (husbandId == -1) {
                try {
                    husbandId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    UpdateMarriage.usage("Invalid husband id: " + args[i]);
                }
                continue;
            }
            if (wifeId == -1) {
                try {
                    wifeId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    UpdateMarriage.usage("Invalid wife id: " + args[i]);
                }
                continue;
            }
            UpdateMarriage.usage("Spurious command line: " + args[i]);
        }
        if (familyName == null) {
            UpdateMarriage.usage("Missing family name");
        } else if (host == null) {
            UpdateMarriage.usage("Missing host");
        } else if (port == -1) {
            UpdateMarriage.usage("Missing port");
        } else if (husbandId == -1) {
            UpdateMarriage.usage("Missing husband id");
        } else if (wifeId == -1) {
            UpdateMarriage.usage("Missing wife id");
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        String name = "rmi://" + host + ":" + port + "/" + familyName;
        try {
            RemoteFamilyTree tree = (RemoteFamilyTree)Naming.lookup(name);
            RemoteMarriage marriage = tree.getMarriage(husbandId, wifeId);
            if (marriage == null) {
                marriage = tree.createMarriage(husbandId, wifeId);
            }
            if (date != null) {
                marriage.setDate(date);
            }
            if (location != null) {
                marriage.setLocation(location);
            }
            out.println("Updated: " + marriage.getDescription());
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
        }
    }
}

