/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.RemoteFamilyTree;
import edu.pdx.cs.joy.family.RemotePerson;
import java.io.PrintStream;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UpdatePerson {
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: java UpdatePerson familyName host port gender firstName lastName");
        err.println("  -middleName middleName");
        err.println("  -mother motherId");
        err.println("  -father fatherId");
        err.println("  -dob Date      The peron's date of birth");
        err.println("  -dod Date      The peron's date of death");
        err.println("");
        err.println("This program updates the information about a person in a remote family tree.");
        err.println("If the person does not already exist in the tree, a new person will be created.");
        err.println("");
        err.println("Dates should be in the form MM/DD/YYYY");
        err.println("");
        System.exit(1);
    }

    public static void main(String[] args) {
        String familyName = null;
        String host = null;
        int port = -1;
        Person.Gender gender = null;
        String firstName = null;
        String lastName = null;
        String middleName = null;
        int motherId = -1;
        int fatherId = -1;
        Date dob = null;
        Date dod = null;
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-middleName")) {
                if (++i >= args.length) {
                    UpdatePerson.usage("Missing middle name");
                }
                middleName = args[i];
                continue;
            }
            if (args[i].equals("-mother")) {
                if (++i >= args.length) {
                    UpdatePerson.usage("Missing mother id");
                }
                try {
                    motherId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    UpdatePerson.usage("Invalid mother id: " + args[i]);
                }
                continue;
            }
            if (args[i].equals("-father")) {
                if (++i >= args.length) {
                    UpdatePerson.usage("Missing father id");
                }
                try {
                    fatherId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    UpdatePerson.usage("Invalid father id: " + args[i]);
                }
                continue;
            }
            if (args[i].equals("-dob")) {
                if (++i >= args.length) {
                    UpdatePerson.usage("Missing date of birth");
                }
                try {
                    dob = df.parse(args[i]);
                }
                catch (ParseException ex) {
                    UpdatePerson.usage("Malformed date: " + args[i]);
                }
                continue;
            }
            if (args[i].equals("-dod")) {
                if (++i >= args.length) {
                    UpdatePerson.usage("Missing date of death");
                }
                try {
                    dod = df.parse(args[i]);
                }
                catch (ParseException ex) {
                    UpdatePerson.usage("Malformed date: " + args[i]);
                }
                continue;
            }
            if (familyName == null) {
                familyName = args[i];
                continue;
            }
            if (host == null) {
                host = args[i];
                continue;
            }
            if (port == -1) {
                try {
                    port = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    UpdatePerson.usage("Invalid port: " + args[i]);
                }
                continue;
            }
            if (gender == null) {
                if (args[i].equalsIgnoreCase("male")) {
                    gender = Person.MALE;
                    continue;
                }
                if (args[i].equalsIgnoreCase("female")) {
                    gender = Person.FEMALE;
                    continue;
                }
                UpdatePerson.usage("Invalid gender: " + args[i]);
                continue;
            }
            if (firstName == null) {
                firstName = args[i];
                continue;
            }
            if (lastName == null) {
                lastName = args[i];
                continue;
            }
            UpdatePerson.usage("Spurious command line: " + args[i]);
        }
        if (familyName == null) {
            UpdatePerson.usage("Missing family name");
        } else if (host == null) {
            UpdatePerson.usage("Missing host");
        } else if (port == -1) {
            UpdatePerson.usage("Missing port");
        } else if (gender == null) {
            UpdatePerson.usage("Missing gender");
        } else if (firstName == null) {
            UpdatePerson.usage("Missing first name");
        } else if (lastName == null) {
            UpdatePerson.usage("Missing last name");
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        String name = "rmi://" + host + ":" + port + "/" + familyName;
        try {
            RemoteFamilyTree tree = (RemoteFamilyTree)Naming.lookup(name);
            RemotePerson person = tree.getPerson(firstName, lastName);
            if (person == null) {
                person = tree.createPerson(gender);
                person.setFirstName(firstName);
                person.setLastName(lastName);
            }
            if (middleName != null) {
                person.setMiddleName(middleName);
            }
            if (motherId != -1) {
                person.setMotherId(motherId);
            }
            if (fatherId != -1) {
                person.setFatherId(fatherId);
            }
            if (dob != null) {
                person.setDateOfBirth(dob);
            }
            if (dod != null) {
                person.setDateOfDeath(dod);
            }
            out.println("Updated: " + person.getDescription());
        }
        catch (Exception ex) {
            ex.printStackTrace(err);
        }
    }
}

