/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.Dumper;
import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PersonMain;
import edu.pdx.cs.joy.family.XmlHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class XmlDumper
extends XmlHelper
implements Dumper {
    private static PrintWriter err = new PrintWriter(System.err, true);
    private PrintWriter pw;

    public XmlDumper(String fileName) throws IOException {
        this(new File(fileName));
    }

    public XmlDumper(File file) throws IOException {
        this(new PrintWriter((Writer)new FileWriter(file), true));
    }

    public XmlDumper(PrintWriter pw) {
        this.pw = pw;
    }

    private static Element getDateElement(Document doc, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Element d = doc.createElement("date");
        int month = cal.get(2);
        Element m = doc.createElement("month");
        d.appendChild(m);
        m.appendChild(doc.createTextNode(String.valueOf(month)));
        int day = cal.get(5);
        Element dy = doc.createElement("day");
        d.appendChild(dy);
        dy.appendChild(doc.createTextNode(String.valueOf(day)));
        int year = cal.get(1);
        Element y = doc.createElement("year");
        d.appendChild(y);
        y.appendChild(doc.createTextNode(String.valueOf(year)));
        return d;
    }

    @Override
    public void dump(FamilyTree tree) {
        String s;
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(this);
            builder.setEntityResolver(this);
            DOMImplementation dom = builder.getDOMImplementation();
            DocumentType docType = dom.createDocumentType("family-tree", "-//Joy of Coding at PSU//DTD Family Tree//EN", "http://www.cs.pdx.edu/~whitlock/dtds/familytree.dtd");
            doc = dom.createDocument(null, "family-tree", docType);
        }
        catch (ParserConfigurationException ex) {
            String s2 = "Illconfigured XML parser";
            throw new FamilyTreeException(s2, ex);
        }
        catch (DOMException ex) {
            String s3 = "While creating XML Document";
            throw new FamilyTreeException(s3, ex);
        }
        HashSet<Marriage> marriages = new HashSet<Marriage>();
        try {
            Element ft = doc.getDocumentElement();
            for (Person person : tree.getPeople()) {
                Person mother;
                Person father;
                Date dod;
                Date dob;
                String lastName;
                String middleName;
                Element p = doc.createElement("person");
                p.setAttribute("id", Integer.toString(person.getId()));
                p.setAttribute("gender", person.getGender() == Person.MALE ? "male" : "female");
                ft.appendChild(p);
                String firstName = person.getFirstName();
                if (firstName != null) {
                    Element fn = doc.createElement("first-name");
                    p.appendChild(fn);
                    fn.appendChild(doc.createTextNode(firstName));
                }
                if ((middleName = person.getMiddleName()) != null) {
                    Element mn = doc.createElement("middle-name");
                    p.appendChild(mn);
                    mn.appendChild(doc.createTextNode(middleName));
                }
                if ((lastName = person.getLastName()) != null) {
                    Element ln = doc.createElement("last-name");
                    p.appendChild(ln);
                    ln.appendChild(doc.createTextNode(lastName));
                }
                if ((dob = person.getDateOfBirth()) != null) {
                    Element d = doc.createElement("dob");
                    p.appendChild(d);
                    d.appendChild(XmlDumper.getDateElement(doc, dob));
                }
                if ((dod = person.getDateOfDeath()) != null) {
                    Element d = doc.createElement("dod");
                    p.appendChild(d);
                    d.appendChild(XmlDumper.getDateElement(doc, dod));
                }
                if ((father = person.getFather()) != null) {
                    Element f = doc.createElement("father-id");
                    p.appendChild(f);
                    f.appendChild(doc.createTextNode(String.valueOf(father.getId())));
                }
                if ((mother = person.getMother()) != null) {
                    Element m = doc.createElement("mother-id");
                    p.appendChild(m);
                    m.appendChild(doc.createTextNode(String.valueOf(mother.getId())));
                }
                marriages.addAll(person.getMarriages());
            }
            for (Marriage marriage : marriages) {
                String location;
                Element m = doc.createElement("marriage");
                m.setAttribute("husband-id", String.valueOf(marriage.getHusband().getId()));
                m.setAttribute("wife-id", String.valueOf(marriage.getWife().getId()));
                ft.appendChild(m);
                Date date = marriage.getDate();
                if (date != null) {
                    m.appendChild(XmlDumper.getDateElement(doc, date));
                }
                if ((location = marriage.getLocation()) == null) continue;
                Element l = doc.createElement("location");
                m.appendChild(l);
                l.appendChild(doc.createTextNode(location));
            }
        }
        catch (DOMException ex) {
            s = "** Exception while building DOM tree";
            throw new FamilyTreeException(s, ex);
        }
        try {
            DOMSource src = new DOMSource(doc);
            StreamResult res = new StreamResult(this.pw);
            TransformerFactory xFactory = TransformerFactory.newInstance();
            Transformer xform = xFactory.newTransformer();
            xform.setOutputProperty("indent", "yes");
            xform.setOutputProperty("doctype-system", "http://www.cs.pdx.edu/~whitlock/dtds/familytree.dtd");
            xform.setOutputProperty("doctype-public", "-//Joy of Coding at PSU//DTD Family Tree//EN");
            xform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xform.setOutputProperty("encoding", "ASCII");
            xform.transform(src, res);
        }
        catch (TransformerException ex) {
            s = "While transforming XML";
            throw new FamilyTreeException(s, ex);
        }
        this.pw.flush();
    }

    public static void main(String[] args) {
        Person me = PersonMain.me();
        Person mom = PersonMain.mom(me);
        Person dad = PersonMain.dad(me);
        me.setMother(mom);
        me.setFather(dad);
        Marriage marriage = new Marriage(dad, mom);
        marriage.setLocation("Durham, NH");
        try {
            DateFormat df = DateFormat.getDateInstance(2);
            marriage.setDate(df.parse("Jul 12, 1969"));
        }
        catch (ParseException ex) {
            System.out.println("** Malformed marriage date?");
            System.exit(1);
        }
        mom.addMarriage(marriage);
        dad.addMarriage(marriage);
        FamilyTree tree = new FamilyTree();
        tree.addPerson(dad);
        tree.addPerson(mom);
        tree.addPerson(me);
        XmlDumper dumper = null;
        if (args.length > 0) {
            try {
                dumper = new XmlDumper(args[0]);
            }
            catch (IOException ex) {
                err.println("** IOException: " + ex);
                System.exit(1);
            }
        } else {
            PrintWriter out = new PrintWriter(System.out, true);
            dumper = new XmlDumper(out);
        }
        dumper.dump(tree);
    }
}

