/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlHelper
implements EntityResolver,
ErrorHandler {
    protected static final String systemID = "http://www.cs.pdx.edu/~whitlock/dtds/familytree.dtd";
    protected static final String publicID = "-//Joy of Coding at PSU//DTD Family Tree//EN";

    XmlHelper() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream stream;
        if (publicId != null && publicId.equals(publicID)) {
            String location = "/edu/pdx/cs/joy/family/familytree.dtd";
            stream = this.getClass().getResourceAsStream(location);
            if (stream != null) {
                return new InputSource(stream);
            }
        }
        try {
            URL url = new URL(systemId);
            stream = url.openStream();
            return new InputSource(stream);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        String s = "Warning while parsing XML (" + ex.getLineNumber() + ":" + ex.getColumnNumber() + "): " + ex.getMessage();
        System.err.println(s);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        String s = "Error while parsing XML (" + ex.getLineNumber() + ":" + ex.getColumnNumber() + "): " + ex.getMessage();
        throw new SAXException(s);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        String s = "Fatal error while parsing XML (" + ex.getLineNumber() + ":" + ex.getColumnNumber() + "): " + ex.getMessage();
        throw new SAXException(s);
    }

    protected static List<String> extractNotesFrom(Element element) {
        ArrayList<String> list = new ArrayList<String>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            Node node = children.item(i);
            if (!(node instanceof Element) || !(child = (Element)node).getTagName().equals("note")) continue;
            list.add(XmlHelper.extractTextFrom(child));
        }
        return list;
    }

    protected static String extractTextFrom(Element element) {
        Text text = (Text)element.getFirstChild();
        return text == null ? "" : text.getData();
    }
}

