/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Parser;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.PrettyPrinter;
import edu.pdx.cs.joy.family.XmlHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser
extends XmlHelper
implements Parser {
    private FamilyTree tree;
    private Reader reader;

    public XmlParser(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public XmlParser(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public XmlParser(Reader reader) {
        this.reader = reader;
    }

    private static String extractString(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    private static int extractInteger(Node node) throws FamilyTreeException {
        String text = XmlParser.extractString(node);
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            throw new FamilyTreeException("Bad integer: " + text);
        }
    }

    private static Date extractDate(Element root) throws FamilyTreeException {
        if (!root.getNodeName().equals("date")) {
            throw new FamilyTreeException("Not a <date>: " + root.getNodeName() + ", '" + root.getNodeValue() + "'");
        }
        Calendar cal = Calendar.getInstance();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getNodeName().equals("month")) {
                cal.set(2, XmlParser.extractInteger(element));
                continue;
            }
            if (element.getNodeName().equals("day")) {
                cal.set(5, XmlParser.extractInteger(element));
                continue;
            }
            if (element.getNodeName().equals("year")) {
                cal.set(1, XmlParser.extractInteger(element));
                continue;
            }
            String s = "Invalidate element in date: " + element.getNodeName();
            throw new FamilyTreeException(s);
        }
        return cal.getTime();
    }

    private void handlePerson(Element root) throws FamilyTreeException {
        int id;
        if (!root.getNodeName().equals("person")) {
            throw new FamilyTreeException("Expecting a <person>");
        }
        Person person = null;
        try {
            id = Integer.parseInt(root.getAttribute("id"));
        }
        catch (NumberFormatException ex) {
            String s = "Person id \"" + root.getAttribute("id") + "\" is not a valid id";
            throw new FamilyTreeException(s);
        }
        Person.Gender gender = root.getAttribute("gender").equals("male") ? Person.MALE : Person.FEMALE;
        person = this.tree.getPerson(id);
        if (person == null) {
            person = new Person(id, gender);
            this.tree.addPerson(person);
        } else if (gender != person.getGender()) {
            String s = "Expecting " + person + " to be " + (gender == Person.MALE ? "MALE" : " FEMALE");
            throw new FamilyTreeException(s);
        }
        NodeList elements = root.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            String s;
            Node n;
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getNodeName().equals("first-name")) {
                person.setFirstName(XmlParser.extractString(element));
                continue;
            }
            if (element.getNodeName().equals("last-name")) {
                person.setLastName(XmlParser.extractString(element));
                continue;
            }
            if (element.getNodeName().equals("middle-name")) {
                person.setMiddleName(XmlParser.extractString(element));
                continue;
            }
            if (element.getNodeName().equals("dob")) {
                Element dob = null;
                NodeList list = element.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    n = list.item(j);
                    if (!(n instanceof Element)) continue;
                    dob = (Element)n;
                    break;
                }
                if (dob == null) {
                    throw new FamilyTreeException("No <date> in <dob>?");
                }
                person.setDateOfBirth(XmlParser.extractDate(dob));
                continue;
            }
            if (element.getNodeName().equals("dod")) {
                Element dod = null;
                NodeList list = element.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    n = list.item(j);
                    if (!(n instanceof Element)) continue;
                    dod = (Element)n;
                    break;
                }
                if (dod == null) {
                    throw new FamilyTreeException("No <date> in <dod>?");
                }
                person.setDateOfDeath(XmlParser.extractDate(dod));
                continue;
            }
            if (element.getNodeName().equals("father-id")) {
                s = XmlParser.extractString(element);
                int fid = 0;
                try {
                    fid = Integer.parseInt(s);
                }
                catch (NumberFormatException ex) {
                    throw new FamilyTreeException("Bad father-id: " + s);
                }
                Person father = this.tree.getPerson(fid);
                if (father == null) {
                    father = new Person(fid, Person.MALE);
                    this.tree.addPerson(father);
                }
                person.setFather(father);
                continue;
            }
            if (!element.getNodeName().equals("mother-id")) continue;
            s = XmlParser.extractString(element);
            int mid = 0;
            try {
                mid = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new FamilyTreeException("Bad mother-id: " + s);
            }
            Person mother = this.tree.getPerson(mid);
            if (mother == null) {
                mother = new Person(mid, Person.FEMALE);
                this.tree.addPerson(mother);
            }
            person.setMother(mother);
        }
    }

    private void handleMarriage(Element root) throws FamilyTreeException {
        if (!root.getNodeName().equals("marriage")) {
            throw new FamilyTreeException("");
        }
        int husband_id = 0;
        int wife_id = 0;
        NamedNodeMap attrs = root.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String id;
            Node attr = attrs.item(i);
            if (attr.getNodeName().equals("husband-id")) {
                id = attr.getNodeValue();
                try {
                    husband_id = Integer.parseInt(id);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new FamilyTreeException("Bad husband id: " + id);
                }
            }
            if (!attr.getNodeName().equals("wife-id")) continue;
            id = attr.getNodeValue();
            try {
                wife_id = Integer.parseInt(id);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FamilyTreeException("Bad wife id: " + id);
            }
        }
        Person husband = this.tree.getPerson(husband_id);
        Person wife = this.tree.getPerson(wife_id);
        Marriage marriage = new Marriage(husband, wife);
        husband.addMarriage(marriage);
        wife.addMarriage(marriage);
        NodeList elements = root.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getNodeName().equals("location")) {
                marriage.setLocation(XmlParser.extractString(element));
                continue;
            }
            if (!element.getNodeName().equals("date")) continue;
            marriage.setDate(XmlParser.extractDate(element));
        }
    }

    @Override
    public FamilyTree parse() throws FamilyTreeException {
        this.tree = new FamilyTree();
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(this);
            builder.setEntityResolver(this);
            doc = builder.parse(new InputSource(this.reader));
        }
        catch (ParserConfigurationException ex) {
            throw new FamilyTreeException("While parsing XML source: " + ex, ex);
        }
        catch (SAXException ex) {
            throw new FamilyTreeException("While parsing XML source: " + ex, ex);
        }
        catch (IOException ex) {
            throw new FamilyTreeException("While parsing XML source: " + ex, ex);
        }
        Element root = (Element)doc.getChildNodes().item(1);
        if (!root.getNodeName().equals("family-tree")) {
            throw new FamilyTreeException("Not a family tree XML source: " + root.getNodeName());
        }
        NodeList stuff = root.getChildNodes();
        for (int i = 0; i < stuff.getLength(); ++i) {
            Node node = stuff.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getNodeName().equals("person")) {
                this.handlePerson(element);
                continue;
            }
            if (element.getNodeName().equals("marriage")) {
                this.handleMarriage(element);
                continue;
            }
            String s = "A family tree should not have a " + element.getNodeName();
            throw new FamilyTreeException(s);
        }
        return this.tree;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("** Missing file name");
            System.exit(1);
        }
        String fileName = args[0];
        try {
            XmlParser parser = new XmlParser(fileName);
            FamilyTree tree = parser.parse();
            PrintWriter out = new PrintWriter(System.out, true);
            PrettyPrinter pretty = new PrettyPrinter(out);
            pretty.dump(tree);
        }
        catch (FileNotFoundException ex) {
            System.err.println("** Could not find file " + fileName);
        }
        catch (FamilyTreeException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

