/*
 * Decompiled with CFR 0.152.
 */
package edu.pdx.cs.joy.family;

import edu.pdx.cs.joy.family.FamilyTree;
import edu.pdx.cs.joy.family.FamilyTreeException;
import edu.pdx.cs.joy.family.Marriage;
import edu.pdx.cs.joy.family.Person;
import edu.pdx.cs.joy.family.RemoteFamilyTree;
import edu.pdx.cs.joy.family.RemoteMarriage;
import edu.pdx.cs.joy.family.RemoteMarriageImpl;
import edu.pdx.cs.joy.family.RemotePerson;
import edu.pdx.cs.joy.family.RemotePersonImpl;
import edu.pdx.cs.joy.family.XmlDumper;
import edu.pdx.cs.joy.family.XmlParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class XmlRemoteFamilyTree
extends UnicastRemoteObject
implements RemoteFamilyTree {
    private transient FamilyTree tree;
    private transient File xmlFile;
    private int highestId;
    private Map<Integer, RemotePerson> remotePersons = new TreeMap<Integer, RemotePerson>();
    private Map<Long, RemoteMarriage> remoteMarriages = new TreeMap<Long, RemoteMarriage>();
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    public XmlRemoteFamilyTree(File xmlFile) throws RemoteException, IOException, FamilyTreeException {
        if (xmlFile.exists()) {
            out.println("Reading Family Tree from " + xmlFile);
            XmlParser parser = new XmlParser(xmlFile);
            this.tree = parser.parse();
            for (Person person : this.tree.getPeople()) {
                if (person.getId() <= this.highestId) continue;
                this.highestId = person.getId();
            }
        } else {
            this.tree = new FamilyTree();
            this.highestId = 0;
        }
        this.xmlFile = xmlFile;
    }

    private RemotePerson getRemotePerson(Person person) throws RemoteException {
        if (person == null) {
            return null;
        }
        int id = person.getId();
        RemotePerson rPerson = this.remotePersons.get(new Integer(id));
        if (rPerson == null) {
            if (!this.tree.containsPerson(id)) {
                return null;
            }
            rPerson = new RemotePersonImpl(this, person);
            this.remotePersons.put(new Integer(person.getId()), rPerson);
        }
        return rPerson;
    }

    @Override
    public RemotePerson createPerson(Person.Gender gender) throws RemoteException {
        Person person = new Person(++this.highestId, gender);
        this.tree.addPerson(person);
        return this.getRemotePerson(person);
    }

    @Override
    public RemotePerson getPerson(int id) throws RemoteException {
        return this.getRemotePerson(this.tree.getPerson(id));
    }

    @Override
    public RemotePerson getPerson(String firstName, String lastName) throws RemoteException {
        Person person = null;
        for (Person p : this.tree.getPeople()) {
            if (!p.getFirstName().equals(firstName) || !p.getLastName().equals(lastName)) continue;
            if (person == null) {
                person = p;
                continue;
            }
            String s = "Multiple people named \"" + firstName + " " + lastName + " exist: " + p + " AND " + person;
            throw new IllegalArgumentException(s);
        }
        if (person == null) {
            return null;
        }
        return this.getPerson(person.getId());
    }

    @Override
    public RemoteMarriage getMarriage(int husbandId, int wifeId) throws RemoteException {
        if (!this.tree.containsPerson(husbandId)) {
            String s = "Could not find person with id " + husbandId;
            throw new IllegalArgumentException(s);
        }
        if (!this.tree.containsPerson(wifeId)) {
            String s = "Could not find person with id " + wifeId;
            throw new IllegalArgumentException(s);
        }
        Person husband = this.tree.getPerson(husbandId);
        for (Marriage marriage : husband.getMarriages()) {
            if (marriage.getWife().getId() != wifeId) continue;
            return this.getRemoteMarriage(marriage);
        }
        return null;
    }

    private RemoteMarriage getRemoteMarriage(Marriage marriage) throws RemoteException {
        long key = (long)marriage.getHusband().getId() << 32 | (long)marriage.getWife().getId();
        RemoteMarriage rMarriage = this.remoteMarriages.get(new Long(key));
        if (rMarriage == null) {
            rMarriage = new RemoteMarriageImpl(marriage);
            this.remoteMarriages.put(new Long(key), rMarriage);
        }
        return rMarriage;
    }

    @Override
    public RemoteMarriage createMarriage(int husbandId, int wifeId) throws RemoteException {
        if (!this.tree.containsPerson(husbandId)) {
            String s = "Could not find person with id " + husbandId;
            throw new IllegalArgumentException(s);
        }
        if (!this.tree.containsPerson(wifeId)) {
            String s = "Could not find person with id " + wifeId;
            throw new IllegalArgumentException(s);
        }
        Person husband = this.tree.getPerson(husbandId);
        Person wife = this.tree.getPerson(wifeId);
        Marriage marriage = new Marriage(husband, wife);
        husband.addMarriage(marriage);
        wife.addMarriage(marriage);
        return this.getRemoteMarriage(marriage);
    }

    @Override
    public Collection<RemotePerson> getLiving() throws RemoteException {
        ArrayList<RemotePerson> living = new ArrayList<RemotePerson>();
        for (Person person : this.tree.getPeople()) {
            if (person.getDateOfBirth() == null || person.getDateOfDeath() != null) continue;
            living.add(this.getRemotePerson(person));
        }
        return living;
    }

    @Override
    public Collection<RemotePerson> getLiving(Date date) throws RemoteException {
        ArrayList<RemotePerson> alive = new ArrayList<RemotePerson>();
        for (Person person : this.tree.getPeople()) {
            Date dob = person.getDateOfBirth();
            Date dod = person.getDateOfDeath();
            if (dob != null && date.before(dob) || dod != null && date.after(dod) || dob == null && dod == null) continue;
            alive.add(this.getRemotePerson(person));
        }
        return alive;
    }

    @Override
    public void shutdown() throws IOException, RemoteException {
        out.println("Writing family tree to " + this.xmlFile.getPath());
        XmlDumper dumper = new XmlDumper(this.xmlFile.getPath());
        dumper.dump(this.tree);
        UnicastRemoteObject.unexportObject(this, false);
    }

    private static void usage(String s) {
        err.println("\n** " + s + "\n");
        err.println("usage: java XmlRemoteFamilyTree [-start xmlFile | -stop] familyName host port");
        err.println("");
        err.println("This program creates a new XmlRemoteFamilyTree that reads its contents from a given XML file and binds it into the RMI registry.  If the XML file doesn't exist, a new one will be created");
        System.exit(1);
    }

    public static void main(String[] args) {
        String xmlFileName = null;
        String familyName = null;
        String host = null;
        int port = -1;
        String command = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-start")) {
                if (++i >= args.length) {
                    XmlRemoteFamilyTree.usage("Missing XML file");
                }
                xmlFileName = args[i];
                command = "START";
                continue;
            }
            if (args[i].equals("-stop")) {
                command = "STOP";
                continue;
            }
            if (familyName == null) {
                familyName = args[i];
                continue;
            }
            if (host == null) {
                host = args[i];
                continue;
            }
            if (port == -1) {
                try {
                    port = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    XmlRemoteFamilyTree.usage("Invalid port: " + args[i]);
                }
                continue;
            }
            XmlRemoteFamilyTree.usage("Spurious command line: " + args[i]);
        }
        if (command == null) {
            XmlRemoteFamilyTree.usage("Missing command");
        }
        if (familyName == null) {
            XmlRemoteFamilyTree.usage("Missing family name");
        }
        if (host == null) {
            XmlRemoteFamilyTree.usage("Missing host name");
        }
        if (port == -1) {
            XmlRemoteFamilyTree.usage("Missing port number");
        }
        if (command.equals("START")) {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            String name = "rmi://" + host + ":" + port + "/" + familyName;
            try {
                XmlRemoteFamilyTree tree = new XmlRemoteFamilyTree(new File(xmlFileName));
                Naming.rebind(name, tree);
                out.println("Successfully bound XmlRemoteFamilyTree");
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        } else if (command.equals("STOP")) {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            String name = "rmi://" + host + ":" + port + "/" + familyName;
            try {
                RemoteFamilyTree tree = (RemoteFamilyTree)Naming.lookup(name);
                tree.shutdown();
                Naming.unbind(name);
            }
            catch (Exception ex) {
                ex.printStackTrace(err);
            }
        } else {
            String s = "Unknown command: " + command;
            throw new IllegalStateException(s);
        }
    }
}

