/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.diff;

import com.deblock.jsondiff.diff.JsonDiff;
import com.deblock.jsondiff.matcher.Path;
import com.deblock.jsondiff.viewer.JsonDiffViewer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;

public class JsonObjectDiff
implements JsonDiff {
    private static final int STRUCTURE_MAX_RATIO = 60;
    private static final int VALUE_MAX_RATIO = 40;
    private final Map<String, JsonDiff> propertiesDiff = new HashMap<String, JsonDiff>();
    private final Map<String, JsonNode> notFoundProperties = new HashMap<String, JsonNode>();
    private final Map<String, JsonNode> extraProperties = new HashMap<String, JsonNode>();
    private final Path path;

    public JsonObjectDiff(Path path) {
        this.path = path;
    }

    public void addNotFoundProperty(String propertyName, JsonNode value) {
        this.notFoundProperties.put(propertyName, value);
    }

    public void addExtraProperty(String propertyName, JsonNode value) {
        this.extraProperties.put(propertyName, value);
    }

    public void addPropertyDiff(String propertyName, JsonDiff diff) {
        this.propertiesDiff.put(propertyName, diff);
    }

    @Override
    public double similarityRate() {
        int notFoundPropertiesCount = this.notFoundProperties.keySet().size();
        int unexpectedPropertiesCount = this.extraProperties.keySet().size();
        int totalPropertiesCount = this.propertiesDiff.keySet().size() + notFoundPropertiesCount + unexpectedPropertiesCount;
        if (totalPropertiesCount == 0) {
            return 100.0;
        }
        double propertiesSimilarityRate = this.propertiesDiff.values().stream().mapToDouble(JsonDiff::similarityRate).sum();
        int structureRatio = (totalPropertiesCount - notFoundPropertiesCount - unexpectedPropertiesCount) * 60 / totalPropertiesCount;
        double equalityRatio = this.propertiesDiff.isEmpty() ? 0.0 : propertiesSimilarityRate * 40.0 / (double)(totalPropertiesCount * 100);
        return (double)structureRatio + equalityRatio;
    }

    @Override
    public void display(JsonDiffViewer viewer) {
        boolean isEmptyObject;
        for (Map.Entry<String, JsonNode> entry : this.notFoundProperties.entrySet()) {
            viewer.missingProperty(this.path.add(Path.PathItem.of(entry.getKey())), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.propertiesDiff.entrySet()) {
            if (((JsonDiff)entry.getValue()).similarityRate() >= 100.0) {
                viewer.matchingProperty(this.path().add(Path.PathItem.of(entry.getKey())), (JsonDiff)entry.getValue());
                continue;
            }
            viewer.nonMatchingProperty(this.path().add(Path.PathItem.of(entry.getKey())), (JsonDiff)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.extraProperties.entrySet()) {
            viewer.extraProperty(this.path().add(Path.PathItem.of(entry.getKey())), (JsonNode)entry.getValue());
        }
        boolean bl = isEmptyObject = this.notFoundProperties.isEmpty() && this.propertiesDiff.isEmpty() && this.extraProperties.isEmpty();
        if (isEmptyObject) {
            viewer.primaryMatching(this.path(), (JsonNode)new ObjectNode(null));
        }
    }

    @Override
    public Path path() {
        return this.path;
    }
}

