/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.matcher;

import com.deblock.jsondiff.diff.JsonArrayDiff;
import com.deblock.jsondiff.diff.JsonDiff;
import com.deblock.jsondiff.matcher.JsonMatcher;
import com.deblock.jsondiff.matcher.PartialJsonMatcher;
import com.deblock.jsondiff.matcher.Path;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LenientJsonArrayPartialMatcher
implements PartialJsonMatcher<ArrayNode> {
    @Override
    public JsonDiff jsonDiff(Path path, ArrayNode expectedValues, ArrayNode receivedValues, JsonMatcher jsonMatcher) {
        JsonArrayDiff diff = new JsonArrayDiff(path);
        int i = 0;
        HashMap diffMap = new HashMap();
        for (JsonNode expectedValue : expectedValues) {
            HashMap<Integer, JsonDiff> map = new HashMap<Integer, JsonDiff>();
            for (int x = 0; x < receivedValues.size(); ++x) {
                map.put(x, jsonMatcher.diff(path.add(Path.PathItem.of(i)), expectedValue, receivedValues.get(x)));
            }
            diffMap.put(i, map);
            ++i;
        }
        List entrySortedByBestMatch = diffMap.entrySet().stream().sorted(Comparator.comparingDouble(this::maxSimilarityRate).reversed()).collect(Collectors.toList());
        HashSet<Integer> alreadyMatchedIndex = new HashSet<Integer>();
        for (Map.Entry entry : entrySortedByBestMatch) {
            Optional<Map.Entry> matchedItem = ((Map)entry.getValue()).entrySet().stream().filter(e -> !alreadyMatchedIndex.contains(e.getKey())).max(Comparator.comparingDouble(e -> ((JsonDiff)e.getValue()).similarityRate()));
            if (matchedItem.isEmpty()) {
                diff.addNoMatch((Integer)entry.getKey(), expectedValues.get(((Integer)entry.getKey()).intValue()));
                continue;
            }
            diff.addDiff((Integer)entry.getKey(), (JsonDiff)matchedItem.get().getValue());
            alreadyMatchedIndex.add((Integer)matchedItem.get().getKey());
        }
        if (alreadyMatchedIndex.size() < receivedValues.size()) {
            List<Integer> receivedIndex = IntStream.range(0, receivedValues.size()).boxed().collect(Collectors.toList());
            receivedIndex.removeAll(alreadyMatchedIndex);
            receivedIndex.forEach(index -> diff.addExtraItem((int)index, receivedValues.get(index.intValue())));
        }
        return diff;
    }

    private double maxSimilarityRate(Map.Entry<Integer, Map<Integer, JsonDiff>> entry) {
        return entry.getValue().values().stream().mapToDouble(JsonDiff::similarityRate).max().orElse(0.0);
    }
}

