/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.matcher;

import com.deblock.jsondiff.diff.JsonDiff;
import com.deblock.jsondiff.diff.MatchedPrimaryDiff;
import com.deblock.jsondiff.diff.UnMatchedPrimaryDiff;
import com.deblock.jsondiff.matcher.JsonMatcher;
import com.deblock.jsondiff.matcher.PartialJsonMatcher;
import com.deblock.jsondiff.matcher.Path;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ValueNode;

public class LenientNumberPrimitivePartialMatcher
implements PartialJsonMatcher<ValueNode> {
    private final PartialJsonMatcher<ValueNode> delegated;

    public LenientNumberPrimitivePartialMatcher(PartialJsonMatcher<ValueNode> delegated) {
        this.delegated = delegated;
    }

    @Override
    public JsonDiff jsonDiff(Path path, ValueNode expectedValue, ValueNode receivedValue, JsonMatcher jsonMatcher) {
        if (expectedValue instanceof NumericNode && receivedValue instanceof NumericNode) {
            int expectedIntValue = expectedValue.intValue();
            int actualIntValue = receivedValue.intValue();
            double expectedDecimalValue = receivedValue.doubleValue() % 1.0;
            double actualDecimalValue = expectedValue.doubleValue() % 1.0;
            if (expectedIntValue != actualIntValue || expectedDecimalValue != actualDecimalValue) {
                return new UnMatchedPrimaryDiff(path, (JsonNode)expectedValue, (JsonNode)receivedValue);
            }
            return new MatchedPrimaryDiff(path, (JsonNode)expectedValue);
        }
        return this.delegated.jsonDiff(path, expectedValue, receivedValue, jsonMatcher);
    }
}

