/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.matcher;

import com.deblock.jsondiff.diff.JsonDiff;
import com.deblock.jsondiff.diff.JsonObjectDiff;
import com.deblock.jsondiff.matcher.JsonMatcher;
import com.deblock.jsondiff.matcher.PartialJsonMatcher;
import com.deblock.jsondiff.matcher.Path;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class StrictJsonObjectPartialMatcher
implements PartialJsonMatcher<ObjectNode> {
    @Override
    public JsonDiff jsonDiff(Path path, ObjectNode expectedJson, ObjectNode receivedJson, JsonMatcher jsonMatcher) {
        JsonObjectDiff jsonDiff = new JsonObjectDiff(path);
        Set receivedJsonFields = StreamSupport.stream(((Iterable)() -> ((ObjectNode)receivedJson).fieldNames()).spliterator(), false).collect(Collectors.toSet());
        expectedJson.fields().forEachRemaining(entry -> {
            String expectedPropertyName = (String)entry.getKey();
            JsonNode expectedValue = (JsonNode)entry.getValue();
            JsonNode receivedValue = receivedJson.get(expectedPropertyName);
            if (receivedValue == null) {
                jsonDiff.addNotFoundProperty(expectedPropertyName, expectedValue);
            } else {
                JsonDiff diff = jsonMatcher.diff(path.add(Path.PathItem.of(expectedPropertyName)), expectedValue, receivedValue);
                jsonDiff.addPropertyDiff(expectedPropertyName, diff);
            }
            receivedJsonFields.remove(expectedPropertyName);
        });
        receivedJson.fields().forEachRemaining(entry -> {
            String receivedPropertyName = (String)entry.getKey();
            JsonNode receivedPropertyValue = (JsonNode)entry.getValue();
            JsonNode expectedValue = expectedJson.get(receivedPropertyName);
            if (expectedValue == null) {
                jsonDiff.addExtraProperty(receivedPropertyName, receivedPropertyValue);
            }
        });
        return jsonDiff;
    }
}

