/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.viewer;

import com.deblock.jsondiff.diff.JsonDiff;
import com.deblock.jsondiff.matcher.Path;
import com.deblock.jsondiff.viewer.JsonDiffViewer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PatchDiffViewer
implements JsonDiffViewer {
    private Object diff = null;

    @Override
    public void matchingProperty(Path path, JsonDiff value) {
        value.display(this);
    }

    @Override
    public void primaryMatching(Path path, JsonNode value) {
        this.diff = this.addPath(this.diff, path, new DiffValue.MatchingProperty(value));
    }

    @Override
    public void nonMatchingProperty(Path path, JsonDiff diff) {
        diff.display(this);
    }

    @Override
    public void missingProperty(Path path, JsonNode value) {
        this.diff = this.addPath(this.diff, path, new DiffValue.MissingProperty(value));
    }

    @Override
    public void extraProperty(Path path, JsonNode extraReceivedValue) {
        this.diff = this.addPath(this.diff, path, new DiffValue.ExtraProperty(extraReceivedValue));
    }

    @Override
    public void primaryNonMatching(Path path, JsonNode expected, JsonNode value) {
        this.diff = this.addPath(this.diff, path, new DiffValue.NonMatchingProperty(expected, value));
    }

    public Object addPath(Object root, Path path, DiffValue diffValue) {
        if (path == null) {
            return diffValue;
        }
        if (path.property instanceof Path.PathItem.ArrayIndex) {
            int index = ((Path.PathItem.ArrayIndex)path.property).index;
            if (root == null) {
                DiffValue.ArrayDiff newRoot = new DiffValue.ArrayDiff();
                newRoot.set(index, this.addPath(null, path.next, diffValue));
                return newRoot;
            }
            if (root instanceof DiffValue.ArrayDiff) {
                DiffValue.ArrayDiff array = (DiffValue.ArrayDiff)root;
                if (array.hasIndex(index) && !(diffValue instanceof DiffValue.ExtraProperty)) {
                    this.addPath(array.get(index), path.next, diffValue);
                } else {
                    array.set(index, this.addPath(array.get(index), path.next, diffValue));
                }
                return array;
            }
            throw new IllegalArgumentException("The path " + path + " is not an array");
        }
        if (path.property instanceof Path.PathItem.ObjectProperty) {
            String propertyName = ((Path.PathItem.ObjectProperty)path.property).property;
            if (root == null) {
                HashMap<String, Object> newRoot = new HashMap<String, Object>();
                newRoot.put(propertyName, this.addPath(null, path.next, diffValue));
                return newRoot;
            }
            if (root instanceof Map) {
                Map map = (Map)root;
                map.put(propertyName, this.addPath(map.get(propertyName), path.next, diffValue));
                return map;
            }
            throw new IllegalArgumentException("The path " + path + " is not an object");
        }
        if (path.property == null) {
            if (path.next != null) {
                return this.addPath(root, path.next, diffValue);
            }
            return this.diff;
        }
        throw new IllegalArgumentException("Unsupported path type " + path.property.getClass());
    }

    public String toString() {
        return "--- actual\n+++ expected\n@@ @@\n" + this.toDiff(this.diff, "", "", "", "");
    }

    private String toDiff(Object diff, String indent, String startOfLine, String endOfLineExpected, String endOfLineActual) {
        if (diff instanceof DiffValue.ArrayDiff) {
            StringBuilder arrayContent = new StringBuilder();
            List<Object> allObjects = ((DiffValue.ArrayDiff)diff).allObjects();
            for (int i = 0; i < allObjects.size(); ++i) {
                Object object = allObjects.get(i);
                arrayContent.append(this.toDiff(object, indent + "  ", indent + "  ", this.commaIfHasNextExpectedProperty(i + 1, allObjects), this.commaIfHasNextActualProperty(i + 1, allObjects))).append("\n");
            }
            return startOfLine + " [\n" + arrayContent + indent + " ]" + endOfLineExpected;
        }
        if (diff instanceof Map) {
            StringBuilder objectContent = new StringBuilder();
            Map diffObject = (Map)diff;
            ArrayList<String> keys = new ArrayList<String>(diffObject.keySet());
            for (int i = 0; i < keys.size(); ++i) {
                Object object = diffObject.get(keys.get(i));
                boolean isObjectNotADiff = object instanceof DiffValue.ArrayDiff || object instanceof Map;
                String propertyPrefix = indent + "  \"" + (String)keys.get(i) + "\":" + (isObjectNotADiff ? "" : " ");
                objectContent.append((String)(isObjectNotADiff ? " " + propertyPrefix : "")).append(this.toDiff(object, isObjectNotADiff ? indent + "  " : propertyPrefix, "", this.commaIfHasNextExpectedProperty(i + 1, diffObject, keys), this.commaIfHasNextActualProperty(i + 1, diffObject, keys))).append("\n");
            }
            return startOfLine + " {\n" + objectContent + indent + " }" + endOfLineExpected;
        }
        if (diff instanceof DiffValue.MatchingProperty) {
            if (endOfLineActual.equals(endOfLineExpected)) {
                return " " + indent + ((DiffValue.MatchingProperty)diff).value.toString() + endOfLineActual;
            }
            return "-" + indent + ((DiffValue.MatchingProperty)diff).value.toString() + endOfLineActual + "\n+" + indent + ((DiffValue.MatchingProperty)diff).value.toString() + endOfLineExpected;
        }
        if (diff instanceof DiffValue.MissingProperty) {
            return "+" + indent + ((DiffValue.MissingProperty)diff).value.toString() + endOfLineExpected;
        }
        if (diff instanceof DiffValue.ExtraProperty) {
            return "-" + indent + ((DiffValue.ExtraProperty)diff).value.toString() + endOfLineActual;
        }
        if (diff instanceof DiffValue.NonMatchingProperty) {
            DiffValue.NonMatchingProperty value = (DiffValue.NonMatchingProperty)diff;
            return "-" + indent + value.value.toString() + endOfLineActual + "\n+" + indent + value.expected.toString() + endOfLineExpected;
        }
        throw new IllegalArgumentException("Unsupported diff type " + diff.getClass());
    }

    private String commaIfHasNextExpectedProperty(int index, Map<String, Object> diffObject, ArrayList<String> keys) {
        for (int i = index; i < keys.size(); ++i) {
            if (!this.isExpectedPart(diffObject.get(keys.get(i)))) continue;
            return ",";
        }
        return "";
    }

    private String commaIfHasNextActualProperty(int index, Map<String, Object> diffObject, ArrayList<String> keys) {
        for (int i = index; i < keys.size(); ++i) {
            if (!this.isActualPart(diffObject.get(keys.get(i)))) continue;
            return ",";
        }
        return "";
    }

    private String commaIfHasNextExpectedProperty(int index, List<Object> allObjects) {
        for (int i = index; i < allObjects.size(); ++i) {
            if (!this.isExpectedPart(allObjects.get(i))) continue;
            return ",";
        }
        return "";
    }

    private String commaIfHasNextActualProperty(int index, List<Object> allObjects) {
        for (int i = index; i < allObjects.size(); ++i) {
            if (!this.isActualPart(allObjects.get(i))) continue;
            return ",";
        }
        return "";
    }

    public boolean isActualPart(Object object) {
        return object instanceof DiffValue.NonMatchingProperty || object instanceof DiffValue.ExtraProperty || object instanceof DiffValue.MatchingProperty || object instanceof Map || object instanceof DiffValue.ArrayDiff;
    }

    public boolean isExpectedPart(Object object) {
        return object instanceof DiffValue.NonMatchingProperty || object instanceof DiffValue.MissingProperty || object instanceof DiffValue.MatchingProperty || object instanceof Map || object instanceof DiffValue.ArrayDiff;
    }

    public static PatchDiffViewer from(JsonDiff jsonDiff) {
        PatchDiffViewer result = new PatchDiffViewer();
        jsonDiff.display(result);
        return result;
    }

    public static class DiffValue {

        public static class NonMatchingProperty
        extends DiffValue {
            public final JsonNode value;
            public final JsonNode expected;

            public NonMatchingProperty(JsonNode expected, JsonNode value) {
                this.expected = expected;
                this.value = value;
            }
        }

        public static class ExtraProperty
        extends DiffValue {
            public final JsonNode value;

            public ExtraProperty(JsonNode extraReceivedValue) {
                this.value = extraReceivedValue;
            }
        }

        public static class MissingProperty
        extends DiffValue {
            public final JsonNode value;

            public MissingProperty(JsonNode value) {
                this.value = value;
            }
        }

        public static class MatchingProperty
        extends DiffValue {
            public final JsonNode value;

            public MatchingProperty(JsonNode value) {
                this.value = value;
            }
        }

        public static class ArrayDiff
        extends DiffValue {
            public final List<Object> diffs = new ArrayList<Object>();
            public final List<ExtraProperty> extraProperty = new ArrayList<ExtraProperty>();

            public void set(int index, Object object) {
                if (object instanceof ExtraProperty) {
                    this.extraProperty.add((ExtraProperty)object);
                } else {
                    while (this.diffs.size() <= index) {
                        this.diffs.add(null);
                    }
                    this.diffs.set(index, object);
                }
            }

            public boolean hasIndex(int index) {
                return this.diffs.size() > index && this.diffs.get(index) != null;
            }

            public Object get(int index) {
                if (!this.hasIndex(index)) {
                    return null;
                }
                return this.diffs.get(index);
            }

            public List<Object> allObjects() {
                return Stream.concat(this.diffs.stream(), this.extraProperty.stream()).collect(Collectors.toList());
            }
        }
    }
}

