/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.diff;

import com.deblock.jsondiff.diff.JsonDiff;
import com.deblock.jsondiff.matcher.Path;
import com.deblock.jsondiff.viewer.JsonDiffViewer;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;

public class JsonArrayDiff
implements JsonDiff {
    private final Map<Integer, JsonNode> valuesWithoutMatch = new HashMap<Integer, JsonNode>();
    private final Map<Integer, JsonDiff> valuesWithMatch = new HashMap<Integer, JsonDiff>();
    private final Map<Integer, JsonNode> extraValues = new HashMap<Integer, JsonNode>();
    private final Path path;

    public JsonArrayDiff(Path path) {
        this.path = path;
    }

    public void addNoMatch(int index, JsonNode expectedValue) {
        this.valuesWithoutMatch.put(index, expectedValue);
    }

    public void addDiff(int index, JsonDiff jsonDiff) {
        this.valuesWithMatch.put(index, jsonDiff);
    }

    public void addExtraItem(int index, JsonNode extraReceivedValue) {
        this.extraValues.put(index, extraReceivedValue);
    }

    @Override
    public double similarityRate() {
        int totalArraySize = this.valuesWithoutMatch.size() + this.valuesWithMatch.size() + this.extraValues.size();
        if (totalArraySize == 0) {
            return 100.0;
        }
        double totalSimilarityRate = this.valuesWithMatch.values().stream().mapToDouble(JsonDiff::similarityRate).sum();
        return totalSimilarityRate / (double)totalArraySize;
    }

    @Override
    public void display(JsonDiffViewer viewer) {
        for (Map.Entry<Integer, JsonDiff> entry : this.valuesWithMatch.entrySet()) {
            if (entry.getValue().similarityRate() == 100.0) {
                viewer.matchingProperty(this.path().add(Path.PathItem.of(entry.getKey())), entry.getValue());
                continue;
            }
            viewer.nonMatchingProperty(this.path().add(Path.PathItem.of(entry.getKey())), entry.getValue());
        }
        for (Map.Entry<Integer, JsonDiff> entry : this.valuesWithoutMatch.entrySet()) {
            viewer.missingProperty(this.path().add(Path.PathItem.of(entry.getKey())), (JsonNode)entry.getValue());
        }
        for (Map.Entry<Integer, JsonDiff> entry : this.extraValues.entrySet()) {
            viewer.extraProperty(this.path().add(Path.PathItem.of(entry.getKey())), (JsonNode)entry.getValue());
        }
    }

    @Override
    public Path path() {
        return this.path;
    }
}

