/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.matcher;

import com.deblock.jsondiff.diff.JsonDiff;
import com.deblock.jsondiff.diff.JsonObjectDiff;
import com.deblock.jsondiff.matcher.JsonMatcher;
import com.deblock.jsondiff.matcher.PartialJsonMatcher;
import com.deblock.jsondiff.matcher.Path;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class LenientJsonObjectPartialMatcher
implements PartialJsonMatcher<ObjectNode> {
    @Override
    public JsonDiff jsonDiff(Path path, ObjectNode expectedJson, ObjectNode receivedJson, JsonMatcher jsonMatcher) {
        JsonObjectDiff jsonDiff = new JsonObjectDiff(path);
        expectedJson.fields().forEachRemaining(entry -> {
            String expectedPropertyName = (String)entry.getKey();
            JsonNode expectedValue = (JsonNode)entry.getValue();
            JsonNode receivedValue = receivedJson.get(expectedPropertyName);
            if (receivedValue == null) {
                jsonDiff.addNotFoundProperty(expectedPropertyName, expectedValue);
            } else {
                JsonDiff diff = jsonMatcher.diff(path.add(Path.PathItem.of(expectedPropertyName)), expectedValue, receivedValue);
                jsonDiff.addPropertyDiff(expectedPropertyName, diff);
            }
        });
        return jsonDiff;
    }
}

