/*
 * Decompiled with CFR 0.152.
 */
package com.deblock.jsondiff.matcher;

import java.util.Objects;

public class Path {
    public static final Path ROOT = new Path();
    public final PathItem property;
    public final Path next;

    public Path() {
        this(null, null);
    }

    private Path(PathItem property, Path next) {
        this.property = property;
        this.next = next;
    }

    private Path(PathItem property) {
        this.property = property;
        this.next = null;
    }

    public Path add(PathItem item) {
        if (this.next == null) {
            return new Path(this.property, new Path(item));
        }
        return new Path(this.property, this.next.add(item));
    }

    public String toString() {
        return (this.property == null ? "$" : this.property) + (String)(this.next == null ? "" : "." + this.next);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return Objects.equals(this.property, path.property) && Objects.equals(this.next, path.next);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.next);
    }

    public static interface PathItem {
        public static PathItem of(String property) {
            return new ObjectProperty(property);
        }

        public static PathItem of(Integer index) {
            return new ArrayIndex(index);
        }

        public static class ObjectProperty
        implements PathItem {
            public final String property;

            public ObjectProperty(String property) {
                this.property = property;
            }

            public String toString() {
                return this.property;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ObjectProperty that = (ObjectProperty)o;
                return Objects.equals(this.property, that.property);
            }

            public int hashCode() {
                return Objects.hash(this.property);
            }
        }

        public static class ArrayIndex
        implements PathItem {
            public final int index;

            public ArrayIndex(int index) {
                this.index = index;
            }

            public String toString() {
                return String.valueOf(this.index);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ArrayIndex that = (ArrayIndex)o;
                return this.index == that.index;
            }

            public int hashCode() {
                return Objects.hash(this.index);
            }
        }
    }
}

