/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

@DefaultKey(value="htmlTool")
public class HtmlTool
extends SafeConfig {
    public static final String DEFAULT_SLUG_SEPARATOR = "-";
    private static final String SEPARATOR_TOC = "_toc_";
    private static final List<String> HEADINGS = Collections.unmodifiableList(Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6"));
    private String outputEncoding = "UTF-8";
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    protected void configure(ValueParser values) {
        Object velocityContext = values.get("velocityContext");
        if (!(velocityContext instanceof ToolContext)) {
            return;
        }
        ToolContext ctxt = (ToolContext)velocityContext;
        Object outputEncodingObj = ctxt.get("outputEncoding");
        if (outputEncodingObj instanceof String) {
            this.outputEncoding = (String)outputEncodingObj;
        }
    }

    public List<String> split(@Nonnull String content, @Nonnull String separatorCssSelector) {
        return this.split(content, separatorCssSelector, JoinSeparator.NO);
    }

    public List<String> splitOnStarts(String content, String separatorCssSelector) {
        List<String> result = this.split(content, separatorCssSelector, JoinSeparator.AFTER);
        if (result == null || result.size() <= 1) {
            return result;
        }
        return result.subList(1, result.size());
    }

    public List<String> split(String content, String separatorCssSelector, String separatorStrategy) {
        JoinSeparator sepStrategy = "before".equals(separatorStrategy) ? JoinSeparator.BEFORE : ("after".equals(separatorStrategy) ? JoinSeparator.AFTER : JoinSeparator.NO);
        return this.split(content, separatorCssSelector, sepStrategy);
    }

    public List<String> split(@Nonnull String content, @Nonnull String separatorCssSelector, @Nonnull JoinSeparator separatorStrategy) {
        Objects.requireNonNull(separatorStrategy);
        Element body = this.parseContent(content);
        Elements separators = body.select(separatorCssSelector);
        if (separators.size() > 0) {
            List<List<Element>> partitions = HtmlTool.split((Collection<Element>)separators, separatorStrategy, body);
            ArrayList<String> sectionHtml = new ArrayList<String>();
            for (List<Element> partition : partitions) {
                String html = HtmlTool.outerHtml(partition);
                if (Strings.isNullOrEmpty((String)html)) continue;
                sectionHtml.add(HtmlTool.outerHtml(partition));
            }
            return sectionHtml;
        }
        return Collections.singletonList(content);
    }

    private static List<List<Element>> split(Collection<Element> separators, JoinSeparator separatorStrategy, Element parent) {
        LinkedList partitions = Lists.newLinkedList();
        for (Element child : parent.children()) {
            if (separators.contains(child)) {
                HtmlTool.getLastPartition(partitions);
                if (separatorStrategy == JoinSeparator.BEFORE) {
                    HtmlTool.getLastPartition(partitions).add(child);
                }
                LinkedList newPartition = Lists.newLinkedList();
                partitions.add(newPartition);
                if (separatorStrategy != JoinSeparator.AFTER) continue;
                newPartition.add(child);
                continue;
            }
            List<List<Element>> childPartitions = HtmlTool.split(separators, separatorStrategy, child);
            HtmlTool.getLastPartition(partitions).add(child);
            if (childPartitions.size() <= 1) continue;
            Elements allChildren = child.children();
            List<Element> firstPartition = childPartitions.get(0);
            allChildren.removeAll(firstPartition);
            for (Element element : allChildren) {
                element.remove();
            }
            for (List list : childPartitions.subList(1, childPartitions.size())) {
                partitions.add(list);
            }
        }
        return partitions;
    }

    private static List<Element> getLastPartition(List<List<Element>> partitions) {
        if (partitions.isEmpty()) {
            LinkedList newPartition = Lists.newLinkedList();
            partitions.add(newPartition);
            return newPartition;
        }
        return partitions.get(partitions.size() - 1);
    }

    private static String outerHtml(List<Element> elements) {
        switch (elements.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return elements.get(0).outerHtml();
            }
        }
        Element root = new Element(Tag.valueOf((String)"div"), "");
        for (Element elem : elements) {
            root.appendChild((Node)elem);
        }
        return root.html();
    }

    public String reorderToTop(String content, String selector, int amount) {
        return this.reorderToTop(content, selector, amount, null);
    }

    public String reorderToTop(String content, String selector, int amount, String wrapRemaining) {
        List<Element> extracted = this.extractElements(content, selector, amount);
        if (extracted.size() > 1) {
            Element body = extracted.get(0);
            if (wrapRemaining != null) {
                HtmlTool.wrapInner(body, wrapRemaining);
            }
            List<Element> elements = extracted.subList(1, extracted.size());
            for (int index = elements.size() - 1; index >= 0; --index) {
                body.prependChild((Node)elements.get(index));
            }
            return body.html();
        }
        return content;
    }

    private static Element wrapInner(Element element, String html) {
        Element topDiv = new Element(Tag.valueOf((String)"div"), "");
        for (Element topElem : element.children()) {
            topElem.remove();
            topDiv.appendChild((Node)topElem);
        }
        element.appendChild((Node)topDiv);
        topDiv.wrap(html);
        topDiv.unwrap();
        return element;
    }

    private List<Element> extractElements(String content, String selector, int amount) {
        Element body = this.parseContent(content);
        Object elements = body.select(selector);
        if (elements.size() > 0) {
            elements = HtmlTool.filterParents((List<Element>)elements);
            if (amount >= 0) {
                elements = elements.subList(0, Math.min(amount, elements.size()));
            }
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                element.remove();
            }
        }
        ArrayList<Element> results = new ArrayList<Element>();
        results.add(body);
        results.addAll((Collection<Element>)elements);
        return results;
    }

    private static List<Element> filterParents(List<Element> elements) {
        ArrayList<Element> filtered = new ArrayList<Element>();
        for (Element element : elements) {
            Elements parentsInter = element.parents();
            parentsInter.retainAll(elements);
            if (!parentsInter.isEmpty()) continue;
            filtered.add(element);
        }
        return filtered;
    }

    @Nonnull
    public ExtractResult extract(String content, String selector, int amount) {
        List<Element> extracted = this.extractElements(content, selector, amount);
        if (extracted.size() > 1) {
            Element body = extracted.get(0);
            List<Element> elements = extracted.subList(1, extracted.size());
            ArrayList<String> elementStr = new ArrayList<String>();
            for (Element el : elements) {
                elementStr.add(el.outerHtml());
            }
            return new DefaultExtractResult(elementStr, body.html());
        }
        return new DefaultExtractResult(Collections.emptyList(), content);
    }

    public String setAttr(String content, String selector, String attributeKey, String value) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        if (elements.size() > 0) {
            for (Element element : elements) {
                element.attr(attributeKey, value);
            }
            return body.html();
        }
        return content;
    }

    private Element parseContent(@Nonnull String content) {
        Document doc = Jsoup.parseBodyFragment((String)content);
        doc.outputSettings().charset(this.outputEncoding);
        return doc.body();
    }

    public List<String> getAttr(String content, String selector, String attributeKey) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        ArrayList<String> attrs = new ArrayList<String>();
        for (Element element : elements) {
            String attrValue = element.attr(attributeKey);
            attrs.add(attrValue);
        }
        return attrs;
    }

    public String addClass(String content, String selector, List<String> classNames, int amount) {
        Element body = this.parseContent(content);
        Object elements = body.select(selector);
        if (amount >= 0) {
            elements = elements.subList(0, Math.min(amount, elements.size()));
        }
        if (elements.size() > 0) {
            for (Element element : elements) {
                for (String className : classNames) {
                    element.addClass(className);
                }
            }
            return body.html();
        }
        return content;
    }

    public String addClass(String content, String selector, List<String> classNames) {
        return this.addClass(content, selector, classNames, -1);
    }

    public String addClass(String content, String selector, String className) {
        return this.addClass(content, selector, Collections.singletonList(className));
    }

    public String wrap(String content, String selector, String wrapHtml, int amount) {
        Element body = this.parseContent(content);
        Object elements = body.select(selector);
        if (amount >= 0) {
            elements = elements.subList(0, Math.min(amount, elements.size()));
        }
        if (elements.size() > 0) {
            for (Element element : elements) {
                element.wrap(wrapHtml);
            }
            return body.html();
        }
        return content;
    }

    public String remove(String content, String selector) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        if (elements.size() > 0) {
            for (Element element : elements) {
                element.remove();
            }
            return body.html();
        }
        return content;
    }

    public String replace(String content, String selector, String replacement) {
        return this.replaceAll(content, Collections.singletonMap(selector, replacement));
    }

    public String replaceAll(String content, Map<String, String> replacements) {
        Element body = this.parseContent(content);
        boolean modified = false;
        for (Map.Entry<String, String> replacementEntry : replacements.entrySet()) {
            Element replacementElem;
            String selector = replacementEntry.getKey();
            String replacement = replacementEntry.getValue();
            Elements elements = body.select(selector);
            if (elements.size() <= 0 || (replacementElem = this.parseContent(replacement).child(0)) == null) continue;
            for (Element element : elements) {
                element.replaceWith((Node)replacementElem.clone());
            }
            modified = true;
        }
        if (modified) {
            return body.html();
        }
        return content;
    }

    public String replaceWith(String content, String selector, String newElement) {
        Element replacementElem;
        Element body = this.parseContent(content);
        boolean modified = false;
        Elements elements = body.select(selector);
        if (elements.size() > 0 && (replacementElem = this.parseContent(newElement).child(0)) != null) {
            for (Element element : elements) {
                List children = element.childNodes();
                Element el = replacementElem.clone();
                for (Node child : children) {
                    el.appendChild(child.clone());
                }
                element.replaceWith((Node)el);
            }
            modified = true;
        }
        if (modified) {
            return body.html();
        }
        return content;
    }

    public List<String> text(String content, String selector) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        ArrayList<String> texts = new ArrayList<String>();
        for (Element element : elements) {
            texts.add(element.text());
        }
        return texts;
    }

    public String headingAnchorToId(String content) {
        Element body = this.parseContent(content);
        List<String> headNoIds = HtmlTool.concat(HEADINGS, ":not([id])", true);
        String nameA = "a[name]:not([href])";
        Elements headingsInnerA = body.select(String.join((CharSequence)", ", HtmlTool.concat(headNoIds, ":has(a[name]:not([href]))", true)));
        boolean modified = false;
        for (Object heading : headingsInnerA) {
            Elements anchors = heading.select("a[name]:not([href])");
            if (anchors.isEmpty()) continue;
            HtmlTool.anchorToId((Element)heading, (Element)anchors.get(0));
            modified = true;
        }
        Elements headingsPreA = body.select(String.join((CharSequence)", ", HtmlTool.concat(headNoIds, "a[name]:not([href]) + ", false)));
        for (Element heading : headingsPreA) {
            Element anchor = heading.previousElementSibling();
            if (anchor == null) continue;
            HtmlTool.anchorToId(heading, anchor);
            modified = true;
        }
        Elements anchorsPreH = body.select(String.join((CharSequence)", ", HtmlTool.concat(headNoIds, " + a[name]:not([href])", true)));
        for (Element anchor : anchorsPreH) {
            Element heading = anchor.previousElementSibling();
            if (heading == null) continue;
            HtmlTool.anchorToId(heading, anchor);
            modified = true;
        }
        if (modified) {
            return body.html();
        }
        return content;
    }

    private static void anchorToId(Element heading, Element anchor) {
        String aName;
        if ("a".equals(anchor.tagName()) && heading.id().isEmpty() && !(aName = anchor.attr("name")).isEmpty()) {
            heading.attr("id", aName);
            anchor.remove();
        }
    }

    public static List<String> concat(List<String> elements, String text, boolean append) {
        ArrayList<String> concats = new ArrayList<String>();
        for (String element : elements) {
            concats.add(append ? element + text : text + element);
        }
        return concats;
    }

    public String ensureHeadingIds(String pageType, String currentPage, String content, String idSeparator) {
        List<String> excludedPages = Arrays.asList("checkstyle-aggregate", "checkstyle");
        Element body = this.parseContent(content);
        if (excludedPages.contains(currentPage)) {
            return content;
        }
        Elements idElems = body.select("*[id]");
        HashSet<String> ids = new HashSet<String>();
        boolean modified = false;
        for (Element idElem : idElems) {
            String id = idElem.id();
            idElem.attr("id", HtmlTool.slug(id, idSeparator));
            modified = true;
            ids.add(idElem.id());
        }
        List<String> headIds = HtmlTool.concat(HEADINGS, "[id]", true);
        Elements headingIds = body.select(String.join((CharSequence)", ", headIds));
        for (Element heading : headingIds) {
            String headingText = heading.text();
            String headingSlug = HtmlTool.slug(headingText, idSeparator);
            if (headingSlug.length() > 50) {
                headingSlug = headingSlug.substring(0, 50);
            }
            String headingId = HtmlTool.generateUniqueId(pageType, currentPage, ids, headingSlug);
            heading.attr("id", headingId);
        }
        List<String> headNoIds = HtmlTool.concat(HEADINGS, ":not([id])", true);
        Elements headingsNoId = body.select(String.join((CharSequence)", ", headNoIds));
        if (!headingsNoId.isEmpty() || modified) {
            for (Element heading : headingsNoId) {
                String headingText = heading.text();
                String headingSlug = HtmlTool.slug(headingText, idSeparator);
                if (headingSlug.length() > 50) {
                    headingSlug = headingSlug.substring(0, 50);
                }
                String headingId = HtmlTool.generateUniqueId(pageType, currentPage, ids, headingSlug);
                heading.attr("id", headingId);
            }
        }
        return body.html();
    }

    private static String generateUniqueId(String pageType, String currentPage, Set<String> ids, String idBase) {
        String id = idBase;
        int counter = 1;
        while (ids.contains(id)) {
            id = idBase + String.valueOf(counter++);
        }
        ids.add(id);
        if ("frame".equals(pageType)) {
            id = currentPage + SEPARATOR_TOC + id;
        }
        return id;
    }

    public String fixTableHeads(String content) {
        Element body = this.parseContent(content);
        Elements tables = body.select("table");
        for (Element table : tables) {
            Elements tableHeadRows = table.select("tbody > tr:has(th)");
            if (tableHeadRows.size() != 1) continue;
            for (Element row : tableHeadRows) {
                row.remove();
                Element thead = new Element(Tag.valueOf((String)"thead"), "");
                thead.appendChild((Node)row);
                table.prependChild((Node)thead);
            }
        }
        return body.html();
    }

    public static String slug(String input) {
        return HtmlTool.slug(input, DEFAULT_SLUG_SEPARATOR);
    }

    private static String slug(String input, String separator) {
        String nowhitespace = WHITESPACE.matcher(input).replaceAll(separator);
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        return NONLATIN.matcher(normalized).replaceAll("").toLowerCase(Locale.ENGLISH);
    }

    public List<? extends IdElement> headingTree(String content, List<String> sections) {
        List<String> sectionContents = this.split(content, "hr");
        List<String> headIds = HtmlTool.concat(HEADINGS, "[id]:not(.no-anchor)", true);
        ArrayList<HeadingItem> headingItems = new ArrayList<HeadingItem>();
        int index = 0;
        for (String sectionContent : sectionContents) {
            String sectionType;
            String string = sectionType = index < sections.size() ? sections.get(index++) : "";
            if ("carousel".equals(sectionType)) continue;
            Element body = this.parseContent(sectionContent);
            Elements headings = body.select(String.join((CharSequence)", ", headIds));
            for (Element heading : headings) {
                headingItems.add(new HeadingItem(heading.id(), heading.nodeName(), heading.text(), HtmlTool.headingIndex(heading)));
            }
        }
        ArrayList<HeadingItem> topHeadings = new ArrayList<HeadingItem>();
        Stack<HeadingItem> parentHeadings = new Stack<HeadingItem>();
        for (HeadingItem heading : headingItems) {
            while (!parentHeadings.isEmpty() && ((HeadingItem)parentHeadings.peek()).headingLevel >= heading.headingLevel) {
                parentHeadings.pop();
            }
            if (parentHeadings.isEmpty()) {
                topHeadings.add(heading);
            } else {
                ((HeadingItem)parentHeadings.peek()).children.add(heading);
            }
            parentHeadings.push(heading);
        }
        return topHeadings;
    }

    private static int headingIndex(Element element) {
        String tagName = element.tagName();
        if (tagName.startsWith("h")) {
            try {
                return Integer.parseInt(tagName.substring(1));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Must be a header tag: " + tagName, ex);
            }
        }
        throw new IllegalArgumentException("Must be a header tag: " + tagName);
    }

    public static interface IdElement {
        public String getId();

        public String getTagName();

        public String getText();

        public int getHeadingLevel();

        public List<? extends IdElement> getItems();
    }

    private static final class HeadingItem
    implements IdElement {
        private final String id;
        private final String tagName;
        private final String text;
        private final int headingLevel;
        private final List<HeadingItem> children = new ArrayList<HeadingItem>();

        private HeadingItem(String id, String tagName, String text, int headingLevel) {
            this.id = id;
            this.tagName = tagName;
            this.text = text;
            this.headingLevel = headingLevel;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getTagName() {
            return this.tagName;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public List<HeadingItem> getItems() {
            return Collections.unmodifiableList(this.children);
        }

        @Override
        public int getHeadingLevel() {
            return this.headingLevel;
        }
    }

    private static final class DefaultExtractResult
    implements ExtractResult {
        private final List<String> extracted;
        private final String remainder;

        private DefaultExtractResult(List<String> extracted, String remainder) {
            this.extracted = extracted;
            this.remainder = remainder;
        }

        @Override
        public List<String> getExtracted() {
            return Collections.unmodifiableList(this.extracted);
        }

        @Override
        public String getRemainder() {
            return this.remainder;
        }
    }

    public static interface ExtractResult {
        public List<String> getExtracted();

        public String getRemainder();
    }

    public static enum JoinSeparator {
        AFTER,
        BEFORE,
        NO;

    }
}

