/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.RenderTool;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.devacfr.maven.skins.reflow.HtmlTool;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.URITool;
import org.devacfr.maven.skins.reflow.Xpp3Utils;
import org.devacfr.maven.skins.reflow.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultKey(value="config")
public class SkinConfigTool
extends SafeConfig
implements ISkinConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkinConfigTool.class);
    public static SimpleDateFormat ISO_8601BASIC_DATE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final String DEFAULT_KEY = "config";
    public static final String SKIN_KEY = "reflowSkin";
    private String key = "config";
    private String skinKey = "reflowSkin";
    private Xpp3Dom globalProperties = new Xpp3Dom("");
    private Xpp3Dom pageProperties = new Xpp3Dom("");
    private String namespace = "";
    private String projectId = null;
    private String fileId = null;
    private Context<?> context = null;
    private MavenProject project = null;
    private DecorationModel decoration;
    private ToolContext velocityContext;

    protected void configure(ValueParser values) {
        Object vc;
        String altSkinKey;
        String altkey = values.getString("key");
        if (altkey != null) {
            this.setKey(altkey);
        }
        if ((altSkinKey = values.getString("skinKey")) != null) {
            this.skinKey = altSkinKey;
        }
        if (!((vc = values.get("velocityContext")) instanceof ToolContext)) {
            return;
        }
        this.velocityContext = (ToolContext)vc;
        Object projectObj = this.velocityContext.get("project");
        if (projectObj instanceof MavenProject) {
            this.project = (MavenProject)projectObj;
            String artifactId = this.project.getArtifactId();
            this.projectId = HtmlTool.slug(artifactId);
        }
        String currentFileObj = this.getCurrentFileName();
        this.fileId = SkinConfigTool.slugFilename(currentFileObj);
        Object decorationObj = this.velocityContext.get("decoration");
        if (!(decorationObj instanceof DecorationModel)) {
            return;
        }
        this.decoration = (DecorationModel)decorationObj;
        Object customObj = this.decoration.getCustom();
        if (!(customObj instanceof Xpp3Dom)) {
            return;
        }
        Xpp3Dom customNode = (Xpp3Dom)customObj;
        Xpp3Dom skinNode = customNode.getChild(this.skinKey);
        String namespaceKey = ":" + this.skinKey;
        if (skinNode == null) {
            for (Xpp3Dom child : customNode.getChildren()) {
                if (!child.getName().endsWith(namespaceKey)) continue;
                skinNode = child;
                break;
            }
        }
        if (skinNode != null) {
            Xpp3Dom pagesNode;
            this.globalProperties = skinNode;
            if (skinNode.getName().endsWith(namespaceKey)) {
                this.namespace = skinNode.getName().substring(0, skinNode.getName().length() - namespaceKey.length() + 1);
            }
            if ((pagesNode = Xpp3Utils.getFirstChild(skinNode, "pages", this.namespace)) != null) {
                String pageProject;
                Xpp3Dom page = Xpp3Utils.getFirstChild(pagesNode, this.fileId, this.namespace);
                if (page != null && this.projectId != null && (pageProject = page.getAttribute("project")) != null && !this.projectId.equals(pageProject)) {
                    page = null;
                }
                if (page != null) {
                    this.pageProperties = page;
                }
            }
            this.velocityContext.put("localResources", (Object)this.is("localResources"));
            this.velocityContext.put("resourcePath", (Object)this.getResourcePath());
            this.context = Context.buildContext(this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current Filename: {}", (Object)currentFileObj);
            LOGGER.debug("Project id: {}", (Object)this.projectId);
            LOGGER.debug("File id: {}", (Object)this.fileId);
            LOGGER.debug("Context: {}", this.context);
            LOGGER.debug("Namespace: {}", (Object)this.namespace);
            LOGGER.debug("---------------------------------------------------");
        }
    }

    protected void setKey(String key) {
        this.key = Objects.requireNonNull(key, "SkinConfigTool key cannot be null");
    }

    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public <T> T getContextValue(@Nonnull String key, @Nonnull Class<T> type) {
        Objects.requireNonNull(type);
        if (String.class.isAssignableFrom(type)) {
            return this.eval("$" + key, type);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setContextValue(@Nonnull String key, @Nullable Object value) {
        Objects.requireNonNull(key);
        if (!(value instanceof String)) {
            throw new UnsupportedOperationException();
        }
        this.eval("#set( $" + key + "= \"" + value.toString() + "\")", Void.class);
    }

    @Override
    @Nullable
    public <T> T getToolbox(@Nonnull String toolName, @Nonnull Class<T> toolType) {
        Objects.requireNonNull(toolType);
        return (T)this.velocityContext.getToolbox().get(Objects.requireNonNull(toolName));
    }

    @Override
    @Nullable
    public Xpp3Dom get(@Nonnull String property) {
        Objects.requireNonNull(property);
        Xpp3Dom propNode = Xpp3Utils.getFirstChild(this.pageProperties, property, this.namespace);
        if (propNode == null) {
            propNode = Xpp3Utils.getFirstChild(this.globalProperties, property, this.namespace);
        }
        return propNode;
    }

    @Nullable
    public String value(@Nonnull String property) {
        Objects.requireNonNull(property);
        Xpp3Dom propNode = this.get(property);
        if (propNode == null) {
            return null;
        }
        return propNode.getValue();
    }

    @Override
    @Nullable
    public <T> T getPropertyValue(@Nonnull String property, @Nonnull Class<T> targetType, @Nullable T defaultValue) {
        Objects.requireNonNull(property, "property is required");
        Objects.requireNonNull(targetType, "targetType is required");
        String value = this.value(property);
        if (value == null) {
            return defaultValue;
        }
        Object returnedValue = value;
        if (targetType.isAssignableFrom(Boolean.class)) {
            returnedValue = Boolean.valueOf(value);
        } else if (targetType.isAssignableFrom(Integer.class)) {
            returnedValue = Integer.valueOf(value);
        } else if (targetType.isAssignableFrom(Long.class)) {
            returnedValue = Long.valueOf(value);
        }
        return (T)returnedValue;
    }

    public List<String> getChildren(Xpp3Dom parentNode) {
        return Xpp3Utils.getChildren(parentNode);
    }

    @Override
    @Nullable
    public <T> T getAttributeValue(@Nonnull String property, @Nonnull String attribute, @Nonnull Class<T> targetType, @Nullable T defaultValue) {
        Objects.requireNonNull(property, "property is required");
        Objects.requireNonNull(attribute, "attribute is required");
        Objects.requireNonNull(targetType, "targetType is required");
        Xpp3Dom element = this.get(property);
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(attribute);
        if (value == null) {
            return defaultValue;
        }
        if ("inherit".equals(value) || Strings.isNullOrEmpty((String)value)) {
            element = Xpp3Utils.getFirstChild(this.globalProperties, property, this.namespace);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Inherit value property '{}': {}", (Object)property, (Object)element);
            }
        }
        if (element == null) {
            return defaultValue;
        }
        value = element.getAttribute(attribute);
        if (value == null) {
            return defaultValue;
        }
        Object returnedValue = value;
        if (targetType.isAssignableFrom(Boolean.class)) {
            returnedValue = Boolean.valueOf(value);
        } else if (targetType.isAssignableFrom(Integer.class)) {
            returnedValue = Integer.valueOf(value);
        } else if (targetType.isAssignableFrom(Long.class)) {
            returnedValue = Long.valueOf(value);
        }
        return (T)returnedValue;
    }

    @Override
    @Nullable
    public <T> T getAttributeValue(@Nonnull Xpp3Dom element, @Nonnull String attribute, @Nonnull Class<T> targetType, @Nullable T defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(attribute);
        if (value == null) {
            return defaultValue;
        }
        Object returnedValue = value;
        if (targetType.isAssignableFrom(Boolean.class)) {
            returnedValue = Boolean.valueOf(value);
        } else if (targetType.isAssignableFrom(Integer.class)) {
            returnedValue = Integer.valueOf(value);
        } else if (targetType.isAssignableFrom(Long.class)) {
            returnedValue = Long.valueOf(value);
        }
        return (T)returnedValue;
    }

    public boolean is(String property) {
        return "true".equals(this.value(property));
    }

    @Override
    public boolean not(String property) {
        return "false".equals(this.value(property));
    }

    public boolean isValue(String property, String value) {
        return value != null && value.equals(this.value(property));
    }

    @Override
    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public String getFileId() {
        return this.fileId;
    }

    @Override
    @Nonnull
    public Context<?> getContext() {
        return this.context;
    }

    public ToolContext getVelocityContext() {
        return this.velocityContext;
    }

    @Override
    @Nonnull
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    @Nonnull
    public DecorationModel getDecoration() {
        return this.decoration;
    }

    @Override
    @Nonnull
    public Xpp3Dom getPageProperties() {
        return this.pageProperties;
    }

    @Override
    @Nonnull
    public Xpp3Dom getGlobalProperties() {
        return this.globalProperties;
    }

    @Override
    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public String getProjectLocation() {
        String projectSiteLoc = this.getProject().getUrl();
        if (!Strings.isNullOrEmpty((String)projectSiteLoc) && !projectSiteLoc.endsWith("/")) {
            projectSiteLoc = projectSiteLoc + "/";
        }
        return projectSiteLoc;
    }

    @Nonnull
    public String getCurrentFileName() {
        return (String)this.velocityContext.get("currentFileName");
    }

    @Nonnull
    public String getCurrentFileLocation() {
        String projectSiteLoc = this.getProjectLocation();
        return URITool.toURI(projectSiteLoc).resolve(this.getCurrentFileName()).toString();
    }

    @Override
    @Nullable
    public <T> T eval(@Nullable String vtl, @Nonnull Class<T> requiredClass) {
        if (vtl == null) {
            return null;
        }
        RenderTool renderTool = (RenderTool)this.getVelocityContext().get("render");
        try {
            return (T)renderTool.eval((org.apache.velocity.context.Context)this.getVelocityContext(), vtl);
        }
        catch (Exception ex) {
            throw new RuntimeException("error when try evaluate '" + vtl + "'", ex);
        }
    }

    @Override
    public String relativeLink(String href) {
        String absoluteLink;
        String currentFileLoc;
        if (href == null) {
            return null;
        }
        if (this.isExternalLink(href)) {
            return href;
        }
        String relativePath = (String)this.velocityContext.get("relativePath");
        String relativeLink = PathTool.calculateLink((String)href, (String)relativePath);
        if (Strings.isNullOrEmpty((String)(relativeLink = relativeLink.replaceAll("\\\\", "/")))) {
            relativeLink = "./";
        }
        if ((currentFileLoc = this.getCurrentFileLocation()).equals(absoluteLink = URITool.toURI(currentFileLoc).resolve(relativeLink).normalize().toString())) {
            relativeLink = "";
        } else {
            String currentFileDir = PathTool.getDirectoryComponent((String)currentFileLoc);
            relativeLink = URITool.relativizeLink(currentFileDir, absoluteLink);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("-- Relative Link ----------------------------------");
            LOGGER.debug("link: {}", (Object)href);
            LOGGER.debug("currentFileLoc: {}", (Object)currentFileLoc);
            LOGGER.debug("absoluteLink: {}", (Object)absoluteLink);
            LOGGER.debug("relativeLink: {}", (Object)relativeLink);
            LOGGER.debug("---------------------------------------------------");
        }
        return relativeLink;
    }

    public boolean isExternalLink(String url) {
        if (url == null) {
            return false;
        }
        String absoluteResourceURL = this.value("absoluteResourceURL");
        if (!Strings.isNullOrEmpty((String)absoluteResourceURL) && url.startsWith(absoluteResourceURL)) {
            return false;
        }
        return url.toLowerCase().startsWith("http:/") || url.toLowerCase().startsWith("https:/") || url.toLowerCase().startsWith("ftp:/") || url.toLowerCase().startsWith("mailto:") || url.toLowerCase().startsWith("file:/") || url.toLowerCase().indexOf("://") != -1;
    }

    @Override
    public boolean isActiveLink(@Nullable String href) {
        String alignedFileName = (String)this.velocityContext.get("alignedFileName");
        if (href == null) {
            return false;
        }
        return Strings.isNullOrEmpty((String)href) || alignedFileName.endsWith("index.html") && ".".equals(href);
    }

    @Nullable
    public static String slugFilename(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        String currentFile = fileName;
        int lastDot = currentFile.lastIndexOf(".");
        if (lastDot >= 0) {
            currentFile = currentFile.substring(0, lastDot);
        }
        return HtmlTool.slug(currentFile.replace("/", "-").replace("\\", "-"));
    }

    @Nonnull
    private String getResourcePath() {
        String absoluteResourceURL = this.value("absoluteResourceURL");
        String projectUrl = this.getProjectLocation();
        String currentFileName = this.getCurrentFileName();
        if (!Strings.isNullOrEmpty((String)projectUrl) && currentFileName != null) {
            if (projectUrl.charAt(projectUrl.length() - 1) != '/') {
                projectUrl = projectUrl + '/';
            }
            String currentFileDir = URITool.toURI(projectUrl).resolve(currentFileName).resolve(".").toString();
            return URITool.relativizeLink(currentFileDir, absoluteResourceURL);
        }
        return (String)this.velocityContext.get("relativePath");
    }

    @Nullable
    public Date getBuildOutputTimestamp() throws ParseException {
        if (!this.velocityContext.containsKey("project.build.outputTimestamp")) {
            return null;
        }
        Object outputTimestamp = this.velocityContext.get("project.build.outputTimestamp");
        if (outputTimestamp != null) {
            return ISO_8601BASIC_DATE.parse(outputTimestamp.toString());
        }
        return null;
    }
}

