/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow;

import com.google.common.base.Strings;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.doxia.site.decoration.inheritance.URIPathDescriptor;
import org.apache.velocity.tools.config.DefaultKey;

@DefaultKey(value="uriTool")
public class URITool {
    @Nullable
    public static String relativizeLink(@Nullable String baseDirUri, @Nullable String link) {
        if (link == null || baseDirUri == null) {
            return link;
        }
        try {
            URIPathDescriptor path = new URIPathDescriptor(baseDirUri, link);
            return URITool.normalisedBaseUrl(path.relativizeLink().toString());
        }
        catch (IllegalArgumentException e) {
            return link;
        }
    }

    @Nonnull
    public static URI toURI(@Nonnull String uri) {
        return URI.create(uri);
    }

    public static URLRebaser createURLRebaser(@Nullable String parentBaseUrl, @Nullable String childBaseUrl) {
        return new URLRebaser(parentBaseUrl, childBaseUrl);
    }

    @Nullable
    public static String normalisedBaseUrl(@Nullable String baseUrl) {
        if (Strings.isNullOrEmpty((String)baseUrl)) {
            return baseUrl;
        }
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public static class URLRebaser {
        private final String oldPath;
        private final String newPath;

        protected URLRebaser(@Nullable String oldPath, @Nullable String newPath) {
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        @Nullable
        public String getNewPath() {
            return this.newPath;
        }

        @Nullable
        public String getOldPath() {
            return this.oldPath;
        }

        public String rebaseLink(@Nullable String link) {
            if (link == null || this.getOldPath() == null) {
                return link;
            }
            if (link.contains("${project.")) {
                throw new IllegalArgumentException("site.xml late interpolation ${project.*} expression found in link: '" + link + "'. Use early interpolation ${this.*}");
            }
            URIPathDescriptor oldPath = new URIPathDescriptor(this.getOldPath(), link);
            return oldPath.rebaseLink(this.getNewPath()).toString();
        }
    }
}

