/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class Xpp3Utils {
    private Xpp3Utils() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static Xpp3Dom getFirstChild(@Nullable Xpp3Dom parentNode, @Nonnull String name, @Nonnull String namespace) {
        if (parentNode == null) {
            return null;
        }
        Objects.requireNonNull(namespace);
        Xpp3Dom child = parentNode.getChild(Objects.requireNonNull(name));
        if (child != null) {
            return child;
        }
        return parentNode.getChild(namespace + name);
    }

    @Nonnull
    public static List<String> getChildren(@Nullable Xpp3Dom parentNode) {
        return Xpp3Utils.getChildrenNodes(parentNode, null).stream().map(node -> node.getName()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<Xpp3Dom> getChildrenNodes(@Nullable Xpp3Dom parentNode, String name) {
        if (parentNode == null) {
            return Collections.emptyList();
        }
        Xpp3Dom[] children = parentNode.getChildren();
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)children.length);
        for (Xpp3Dom child : children) {
            if (name != null) {
                if (!name.equals(child.getName())) continue;
                list.add(child);
                continue;
            }
            list.add(child);
        }
        return list;
    }
}

