/*
 * Decompiled with CFR 0.152.
 */
package org.devacfr.maven.skins.reflow.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.devacfr.maven.skins.reflow.HtmlTool;
import org.devacfr.maven.skins.reflow.ISkinConfig;
import org.devacfr.maven.skins.reflow.context.BodyContext;
import org.devacfr.maven.skins.reflow.context.ContextType;
import org.devacfr.maven.skins.reflow.context.DocumentContext;
import org.devacfr.maven.skins.reflow.context.FrameContext;
import org.devacfr.maven.skins.reflow.context.PageContext;
import org.devacfr.maven.skins.reflow.model.Component;
import org.devacfr.maven.skins.reflow.model.Footer;
import org.devacfr.maven.skins.reflow.model.NavSideMenu;
import org.devacfr.maven.skins.reflow.model.Navbar;
import org.devacfr.maven.skins.reflow.model.ScrollTop;
import org.devacfr.maven.skins.reflow.model.SideNavMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Context<T extends Context<?>>
extends Component {
    private static final Map<String, String> ICON_REPLACEMENTS = ImmutableMap.builder().put((Object)"img[src$=images/add.gif]", (Object)"<i class=\"fas fa-plus\"></i>").put((Object)"img[src$=images/remove.gif]", (Object)"<i class=\"fas fa-minus\"></i>").put((Object)"img[src$=images/fix.gif]", (Object)"<i class=\"fas fa-wrench\"></i>").put((Object)"img[src$=images/update.gif]", (Object)"<i class=\"fas fa-redo\"></i>").put((Object)"img[src$=images/icon_help_sml.gif]", (Object)"<i class=\"fas fa-question\"></i>").put((Object)"img[src$=images/icon_success_sml.gif]", (Object)"<i class=\"fas fa-check-circle\"></i>").put((Object)"img[src$=images/icon_warning_sml.gif]", (Object)"<i class=\"fas fa-exclamation-triangle\"></i>").put((Object)"img[src$=images/icon_error_sml.gif]", (Object)"<i class=\"fas fa-exclamation-circle\"></i>").put((Object)"img[src$=images/icon_info_sml.gif]", (Object)"<i class=\"fas fa-info\"></i>").build();
    private static final Logger LOGGER = LoggerFactory.getLogger(Context.class);
    private ContextType type;
    private final Navbar navbar;
    private final Footer footer;
    private final ScrollTop scrollTop;

    @Nonnull
    public static Context<?> buildContext(@Nonnull ISkinConfig config) {
        Objects.requireNonNull(config);
        ContextType type = ContextType.page;
        List<SideNavMenuItem> allSideNaveMenuItems = NavSideMenu.findAllSideNavMenuItems(config);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("findAllSideNavMenuItems: " + allSideNaveMenuItems);
        }
        Xpp3Dom pageProperties = config.getPageProperties();
        String fileId = config.getFileId();
        if (pageProperties != null) {
            if (pageProperties.getAttribute("type") != null) {
                type = ContextType.valueOf(pageProperties.getAttribute("type"));
            }
            if (allSideNaveMenuItems.stream().filter(item -> fileId.equals(item.getSlugName())).count() > 0L) {
                type = ContextType.frame;
            }
        }
        Context context = null;
        switch (type) {
            case doc: {
                context = new DocumentContext(config);
                break;
            }
            case frame: {
                Optional<SideNavMenuItem> menuItem = allSideNaveMenuItems.stream().filter(item -> fileId.equals(item.getSlugName())).findFirst();
                SideNavMenuItem item2 = menuItem.get();
                String documentParent = item2.getParent();
                context = new FrameContext(config, documentParent);
                break;
            }
            case body: {
                context = new BodyContext(config);
                break;
            }
            default: {
                context = new PageContext(config);
            }
        }
        return context;
    }

    public Context(@Nonnull ISkinConfig config, @Nonnull ContextType type) {
        Objects.requireNonNull(config);
        this.withType(Objects.requireNonNull(type));
        this.navbar = new Navbar(config);
        this.scrollTop = new ScrollTop(config);
        this.footer = new Footer(config);
        this.initialize(config);
        this.addChildren(this.navbar, this.scrollTop, this.footer);
    }

    protected void initialize(@Nonnull ISkinConfig config) {
        if (!config.not("anchorJS")) {
            this.addCssOptions("anchorjs-enabled");
        }
    }

    public String preRender(@Nonnull ISkinConfig skinConfig) {
        return this.onPreRender(skinConfig, this.getBodyContent(skinConfig));
    }

    @Override
    protected String onPreRender(ISkinConfig skinConfig, String bodyContent) {
        HtmlTool htmlTool = this.getHtmlTool(skinConfig);
        String content = bodyContent;
        if (!skinConfig.not("imgLightbox")) {
            content = htmlTool.setAttr(content, "a[href$=jpg], a[href$=JPG], a[href$=jpeg], a[href$=JPEG], a[href$=png], a[href$=gif],a[href$=bmp]:has(img)", "data-lightbox", "page");
        }
        if (!skinConfig.not("imgLightbox")) {
            content = htmlTool.setAttr(content, "a[href$=jpg], a[href$=JPG], a[href$=jpeg], a[href$=JPEG], a[href$=png], a[href$=gif], a[href$=bmp]:has(img)", "data-lightbox", "page");
        }
        if (!skinConfig.not("html5Anchor")) {
            content = htmlTool.headingAnchorToId(content);
        }
        if (!skinConfig.not("bootstrapCss")) {
            content = htmlTool.addClass(content, "table.bodyTable", Lists.newArrayList((Object[])new String[]{"table", "table-striped", "table-hover"}));
            content = htmlTool.addClass(content, "img", Lists.newArrayList((Object[])new String[]{"img-fluid"}));
            content = htmlTool.fixTableHeads(content);
        }
        if (!skinConfig.not("bootstrapIcons")) {
            content = htmlTool.replaceAll(content, ICON_REPLACEMENTS);
            content = htmlTool.replaceWith(content, "tt", "<code class=\"literal\">");
        }
        return super.onPreRender(skinConfig, content);
    }

    public Navbar getNavbar() {
        return this.navbar;
    }

    public ScrollTop getScrollTop() {
        return this.scrollTop;
    }

    public Footer getFooter() {
        return this.footer;
    }

    protected T withType(ContextType type) {
        this.type = type;
        return this.self();
    }

    public String getType() {
        return this.type.name();
    }

    protected T self() {
        return (T)this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

